/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.mds.distance;

import java.util.HashMap;
import java.util.Map;
import jp.sourceforge.talisman.mds.distance.CentroidClusterDistanceCalculator;
import jp.sourceforge.talisman.mds.distance.CityBlockItemDistanceCalculator;
import jp.sourceforge.talisman.mds.distance.ClusterDistanceAlgorithm;
import jp.sourceforge.talisman.mds.distance.ClusterDistanceCalculator;
import jp.sourceforge.talisman.mds.distance.DistanceCalculatorNotFoundException;
import jp.sourceforge.talisman.mds.distance.DominanceMetricCalculator;
import jp.sourceforge.talisman.mds.distance.FurthestNeighborClusterDistanceCalculator;
import jp.sourceforge.talisman.mds.distance.GroupAverageClusterDistanceCalculator;
import jp.sourceforge.talisman.mds.distance.ItemDistanceAlgorithm;
import jp.sourceforge.talisman.mds.distance.ItemDistanceCalculator;
import jp.sourceforge.talisman.mds.distance.MinkowskyItemDistanceCalculator;
import jp.sourceforge.talisman.mds.distance.NearestNeighborClusterDistanceCalculator;
import jp.sourceforge.talisman.mds.distance.NormalizedEuclideanItemDistanceCalculator;
import jp.sourceforge.talisman.mds.distance.SquaredEuclideanItemDistanceCalculator;
import jp.sourceforge.talisman.mds.distance.WardsClusterDistanceCalculator;

public class DistanceCalculatorFactory {
    private static final DistanceCalculatorFactory factory = new DistanceCalculatorFactory();
    private Map<ItemDistanceAlgorithm, ItemDistanceCalculator> itemMap = new HashMap<ItemDistanceAlgorithm, ItemDistanceCalculator>();
    private Map<ClusterDistanceAlgorithm, Class<? extends ClusterDistanceCalculator>> clusterMap = new HashMap<ClusterDistanceAlgorithm, Class<? extends ClusterDistanceCalculator>>();

    private DistanceCalculatorFactory() {
        this.itemMap.put(ItemDistanceAlgorithm.CITY_BLOCK_DISTANCE, new CityBlockItemDistanceCalculator());
        this.itemMap.put(ItemDistanceAlgorithm.DOMINANCE_METRIC, new DominanceMetricCalculator());
        this.itemMap.put(ItemDistanceAlgorithm.NORMALIZED_EUCLIDEAN_DISTANCE, new NormalizedEuclideanItemDistanceCalculator());
        this.itemMap.put(ItemDistanceAlgorithm.SQUARED_EUCLIDEAN_DISTANCE, new SquaredEuclideanItemDistanceCalculator());
        this.clusterMap.put(ClusterDistanceAlgorithm.CENTROID_METHOD, CentroidClusterDistanceCalculator.class);
        this.clusterMap.put(ClusterDistanceAlgorithm.FURTHEST_NEIGHBOR_METHOD, FurthestNeighborClusterDistanceCalculator.class);
        this.clusterMap.put(ClusterDistanceAlgorithm.NEAREST_NEIGHBOR_METHOD, NearestNeighborClusterDistanceCalculator.class);
        this.clusterMap.put(ClusterDistanceAlgorithm.GROUP_AVERAGE_METHOD, GroupAverageClusterDistanceCalculator.class);
        this.clusterMap.put(ClusterDistanceAlgorithm.WARDS_METHOD, WardsClusterDistanceCalculator.class);
    }

    public static DistanceCalculatorFactory getInstance() {
        return factory;
    }

    public synchronized ClusterDistanceCalculator getClusterDistanceCalculator(ClusterDistanceAlgorithm algorithm, ItemDistanceAlgorithm itemAlgorithm) throws DistanceCalculatorNotFoundException {
        try {
            Class<? extends ClusterDistanceCalculator> clazz = this.clusterMap.get((Object)algorithm);
            ClusterDistanceCalculator cd = clazz.newInstance();
            if (itemAlgorithm == null) {
                throw new DistanceCalculatorNotFoundException("item distance algorithm is null");
            }
            cd.setItemDistanceCalculator(itemAlgorithm);
            return cd;
        }
        catch (DistanceCalculatorNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DistanceCalculatorNotFoundException((Object)((Object)algorithm) + " not found");
        }
    }

    public synchronized ItemDistanceCalculator getItemDistanceCalculator(ItemDistanceAlgorithm distance) {
        ItemDistanceCalculator dc = distance == ItemDistanceAlgorithm.MINKOWSKY_DISTANCE ? new MinkowskyItemDistanceCalculator() : this.itemMap.get((Object)distance);
        return dc;
    }

    public ItemDistanceCalculator getDefaultItemDistanceCalculator() {
        return this.getItemDistanceCalculator(ItemDistanceAlgorithm.SQUARED_EUCLIDEAN_DISTANCE);
    }
}

