/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.mds.distance;

import jp.sourceforge.talisman.mds.Item;
import jp.sourceforge.talisman.mds.cluster.Cluster;
import jp.sourceforge.talisman.mds.distance.AbstractClusterDistanceCalculator;
import jp.sourceforge.talisman.mds.distance.ClusterDistanceAlgorithm;
import jp.sourceforge.talisman.mds.distance.ItemDistanceAlgorithm;

public class CentroidClusterDistanceCalculator
extends AbstractClusterDistanceCalculator {
    public CentroidClusterDistanceCalculator() {
    }

    public CentroidClusterDistanceCalculator(ItemDistanceAlgorithm ida) {
        super(ida);
    }

    public ClusterDistanceAlgorithm getAlgorithm() {
        return ClusterDistanceAlgorithm.CENTROID_METHOD;
    }

    public double calculate(Cluster c1, Cluster c2) {
        Item item1 = c1.getMedian();
        Item item2 = c2.getMedian();
        return this.getItemDistanceCalculator().calculate(item1, item2);
    }

    public double update(Cluster ci, Cluster cj, Cluster ck, double dij, double dik, double djk) {
        int sum = ci.getSize() + cj.getSize();
        return dik * (double)ci.getSize() / (double)sum + djk * (double)cj.getSize() / (double)sum - dij * (double)ci.getSize() * (double)cj.getSize() / (double)(sum * sum);
    }
}

