/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.mds.distance;

import jp.sourceforge.talisman.mds.cluster.Cluster;
import jp.sourceforge.talisman.mds.distance.ClusterDistanceAlgorithm;
import jp.sourceforge.talisman.mds.distance.ClusterDistanceCalculator;
import jp.sourceforge.talisman.mds.distance.DistanceCalculatorFactory;
import jp.sourceforge.talisman.mds.distance.ItemDistanceAlgorithm;
import jp.sourceforge.talisman.mds.distance.ItemDistanceCalculator;

public abstract class AbstractClusterDistanceCalculator
implements ClusterDistanceCalculator {
    private ItemDistanceCalculator calculator;

    public AbstractClusterDistanceCalculator(ItemDistanceAlgorithm algorithm) {
        this.setItemDistanceCalculator(algorithm);
    }

    public AbstractClusterDistanceCalculator() {
    }

    public final ItemDistanceCalculator getItemDistanceCalculator() {
        return this.calculator;
    }

    public final void setItemDistanceCalculator(ItemDistanceAlgorithm algorithm) {
        if (algorithm == null) {
            throw new NullPointerException();
        }
        this.setItemDistanceCalculator(AbstractClusterDistanceCalculator.getCalculator(algorithm));
    }

    public void setItemDistanceCalculator(ItemDistanceCalculator idc) {
        if (idc == null) {
            throw new NullPointerException();
        }
        this.calculator = idc;
    }

    public static final ItemDistanceCalculator getCalculator(ItemDistanceAlgorithm algorithm) {
        DistanceCalculatorFactory factory = DistanceCalculatorFactory.getInstance();
        return factory.getItemDistanceCalculator(algorithm);
    }

    public abstract double update(Cluster var1, Cluster var2, Cluster var3, double var4, double var6, double var8);

    public abstract double calculate(Cluster var1, Cluster var2);

    public abstract ClusterDistanceAlgorithm getAlgorithm();
}

