/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.mds.cluster;

import java.util.LinkedList;
import jp.sourceforge.talisman.mds.Item;
import jp.sourceforge.talisman.mds.cluster.AbstractClusteringMethod;
import jp.sourceforge.talisman.mds.cluster.Cluster;
import jp.sourceforge.talisman.mds.cluster.ClusteringParameter;
import jp.sourceforge.talisman.mds.cluster.HierarchicalClusteringParameter;
import jp.sourceforge.talisman.mds.cluster.ParameterTypeMismatchException;
import jp.sourceforge.talisman.mds.distance.ClusterDistanceCalculator;

class HierarchicalClusteringMethod
extends AbstractClusteringMethod {
    public HierarchicalClusteringMethod(ClusteringParameter param) throws ParameterTypeMismatchException {
        super(param);
        if (!(param instanceof HierarchicalClusteringParameter)) {
            throw new ParameterTypeMismatchException("HierarchicalClusteringParameter is required");
        }
    }

    public HierarchicalClusteringMethod(HierarchicalClusteringParameter param) {
        super(param);
    }

    protected Cluster[] doClustering(Item[] items, ClusteringParameter parameter) {
        HierarchicalClusteringParameter param = (HierarchicalClusteringParameter)parameter;
        Cluster[] clusters = this.initClusters(items, param);
        LinkedList<Cluster> list = new LinkedList<Cluster>();
        for (Cluster c : clusters) {
            list.add(c);
        }
        ClusterDistanceCalculator cdc = param.getClusterDistanceCalculator();
        while (list.size() > param.getNumberOfCluster()) {
            Cluster cluster1 = null;
            Cluster cluster2 = null;
            double distance = Double.MAX_VALUE;
            for (int i = 0; i < list.size(); ++i) {
                Cluster c1 = (Cluster)list.get(i);
                for (int j = i + 1; j < list.size(); ++j) {
                    Cluster c2 = (Cluster)list.get(j);
                    double d = cdc.calculate(c1, c2);
                    if (!(d < distance)) continue;
                    distance = d;
                    cluster1 = c1;
                    cluster2 = c2;
                }
            }
            if (cluster1 == null || cluster2 == null) continue;
            list.remove(cluster1);
            list.remove(cluster2);
            Cluster c = new Cluster();
            c.setName(cluster1.getName() + ", " + cluster2.getName());
            for (Item item : cluster1) {
                c.addItem(item);
            }
            for (Item item : cluster2) {
                c.addItem(item);
            }
            list.add(c);
        }
        return list.toArray(new Cluster[list.size()]);
    }

    private Cluster[] initClusters(Item[] items, HierarchicalClusteringParameter param) {
        Cluster[] clusters = new Cluster[items.length];
        for (int i = 0; i < items.length; ++i) {
            clusters[i] = new Cluster();
            clusters[i].setName(items[i].getName());
            clusters[i].addItem(items[i]);
        }
        return clusters;
    }
}

