/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.mds.cluster;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import jp.sourceforge.talisman.mds.Item;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cluster
implements Serializable,
Iterable<Item> {
    private static final long serialVersionUID = -8171194255774476986L;
    private String name;
    private Set<Item> itemSet = new LinkedHashSet<Item>();
    private Item median;

    public Cluster() {
    }

    public Cluster(Cluster cluster) {
        if (cluster.getName() != null) {
            this.setName(cluster.getName());
        }
        for (Item item : cluster) {
            this.addItem(item);
        }
    }

    public synchronized void addItem(Item item) {
        this.itemSet.add(item);
        this.median = null;
    }

    public synchronized Item getItem(int targetIndex) {
        int index = 0;
        Item targetItem = null;
        for (Item item : this) {
            if (index == targetIndex) {
                targetItem = item;
                break;
            }
            ++index;
        }
        return targetItem;
    }

    public synchronized boolean removeItem(Item item) {
        this.median = null;
        return this.itemSet.remove(item);
    }

    public synchronized Item remove(int removeIndex) {
        this.median = null;
        LinkedHashSet<Item> newItemSet = new LinkedHashSet<Item>();
        int index = 0;
        Item removedItem = null;
        for (Item item : this) {
            if (index == removeIndex) {
                removedItem = item;
            } else {
                newItemSet.add(item);
            }
            ++index;
        }
        this.itemSet = newItemSet;
        return removedItem;
    }

    @Override
    public Iterator<Item> iterator() {
        return this.itemSet.iterator();
    }

    public int getSize() {
        return this.itemSet.size();
    }

    public boolean isContain(Item item) {
        return this.itemSet.contains(item);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public synchronized Item getMedian() {
        if (this.median == null) {
            this.median = this.calculateMedian();
        }
        return this.median;
    }

    public synchronized Item[] getItems() {
        return this.itemSet.toArray(new Item[this.getSize()]);
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.getName() != null) {
            sb.append(this.getName()).append(" ");
        }
        sb.append("{");
        int index = 0;
        for (Item item : this) {
            if (index != 0) {
                sb.append(", ");
            }
            sb.append(item);
            ++index;
        }
        sb.append(" }");
        return new String(sb);
    }

    private Item calculateMedian() {
        if (this.itemSet.size() == 1) {
            return new Item(this.itemSet.toArray(new Item[1])[0]);
        }
        if (this.itemSet.size() == 0) {
            return null;
        }
        Item[] items = this.itemSet.toArray(new Item[this.itemSet.size()]);
        int dim = items[0].getDimension();
        double[] median = new double[dim];
        for (Item item : items) {
            for (int i = 0; i < dim; ++i) {
                int n = i;
                median[n] = median[n] + item.get(i).doubleValue();
            }
        }
        for (int i = 0; i < dim; ++i) {
            median[i] = median[i] / (double)items.length;
        }
        return new Item("<median>", median);
    }
}

