/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.mds;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Item
implements Iterable<Number> {
    private List<Number> numbers = new ArrayList<Number>();
    private String name;
    private int limit = -1;
    private int groupId = 0;

    public Item(Item item) {
        if (item == null) {
            throw new NullPointerException();
        }
        this.setName(item.getName());
        this.setGroupId(item.getGroupId());
        for (Number number : item) {
            this.add(number);
        }
        if (item.isLimitted()) {
            this.setLimit(item.getDimension());
        }
    }

    public Item(String label, double[] values) {
        this(label);
        for (int i = 0; i < values.length; ++i) {
            this.add(i, values[i]);
        }
    }

    public Item(String label, int dimension) {
        this(label);
        for (int i = 0; i < dimension; ++i) {
            this.add(i, 0);
        }
    }

    public Item(String label) {
        this.setName(label);
    }

    public void add(int index, Number number) {
        if (this.isLimitted() && index >= this.getDimension()) {
            throw new IndexOutOfBoundsException(String.format("out of range: %d >= %d", index, this.getDimension()));
        }
        this.numbers.add(index, number);
    }

    public void add(Number number) {
        this.numbers.add(number);
    }

    public Number get(int index) {
        if (this.isLimitted() && index >= this.getDimension()) {
            throw new IndexOutOfBoundsException(String.format("out of range: %d >= %d", index, this.getDimension()));
        }
        return this.numbers.get(index);
    }

    public void set(int index, Number number) {
        if (this.isLimitted() && index >= this.getDimension()) {
            throw new IndexOutOfBoundsException(String.format("out of range: %d >= %d", index, this.getDimension()));
        }
        this.numbers.set(index, number);
    }

    public void remove(int index) {
        if (this.isLimitted() && index >= this.getDimension()) {
            throw new IndexOutOfBoundsException(String.format("out of range: %d >= %d", index, this.getDimension()));
        }
        this.numbers.remove(index);
    }

    public int getGroupId() {
        return this.groupId;
    }

    public String getName() {
        return this.name;
    }

    public void setLimit(int limit) {
        if (limit <= 0) {
            throw new IllegalArgumentException("positive value required: " + limit);
        }
        this.limit = limit;
    }

    public boolean isLimitted() {
        return this.limit > 0;
    }

    public void removeLimit() {
        this.limit = -1;
    }

    public int getDimension() {
        if (this.isLimitted() && this.limit < this.numbers.size()) {
            return this.limit;
        }
        return this.numbers.size();
    }

    public int getNonLimittedDimension() {
        return this.numbers.size();
    }

    @Override
    public Iterator<Number> iterator() {
        return new ArrayList<Number>(this.numbers).iterator();
    }

    public void setGroupId(int groupId) {
        this.groupId = groupId;
    }

    public void setName(String label) {
        if (label == null) {
            throw new NullPointerException();
        }
        this.name = label;
    }

    public boolean equals(Object o) {
        if (o instanceof Item) {
            Item item = (Item)o;
            boolean flag = item.getDimension() == this.getDimension();
            for (int i = 0; i < this.getDimension(); ++i) {
                boolean bl = flag = flag && Math.abs(item.get(i).doubleValue() - this.get(i).doubleValue()) < 1.0E-6;
                if (!flag) break;
            }
            return flag;
        }
        return false;
    }

    public boolean isSame(Item item) {
        if (this.equals(item)) {
            return this.getName().equals(item.getName()) && this.getGroupId() == item.getGroupId();
        }
        return false;
    }

    public synchronized String toString() {
        return this.toString(this.getDimension());
    }

    public synchronized String toString(int limits) {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append("[").append(this.getGroupId()).append("] (");
        for (int i = 0; i < limits || i < this.getDimension(); ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            Number num = this.get(i);
            String format = "%d";
            if (num instanceof Float || num instanceof Double || num instanceof BigDecimal) {
                format = "%g";
            }
            sb.append(String.format(format, this.get(i)));
        }
        sb.append(")");
        return new String(sb);
    }
}

