/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.stigmata.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jp.sourceforge.stigmata.utils.FullyClassName;
import jp.sourceforge.stigmata.utils.WellknownClassJudgeRule;

public class WellknownClassManager
implements Iterable<WellknownClassJudgeRule> {
    private List<WellknownClassJudgeRule> rules = new ArrayList<WellknownClassJudgeRule>();
    private static final int OPCODE_ACC_PUBLIC = 1;
    private static final int OPCODE_ACC_PRIVATE = 2;
    private static final int OPCODE_ACC_PROTECTED = 4;
    private static final int OPCODE_ACC_STATIC = 8;
    private static final int OPCODE_ACC_FINAL = 16;

    public WellknownClassManager() {
    }

    public WellknownClassManager(WellknownClassManager manager) {
        this.rules = new ArrayList<WellknownClassJudgeRule>(manager.rules);
    }

    public void remove(WellknownClassJudgeRule rule) {
        this.rules.remove(rule);
    }

    public void remove(String value, WellknownClassJudgeRule.MatchType matchType, WellknownClassJudgeRule.MatchPartType partType) {
        this.remove(new WellknownClassJudgeRule(value, matchType, partType));
    }

    public void clear() {
        this.rules.clear();
    }

    @Override
    public synchronized Iterator<WellknownClassJudgeRule> iterator() {
        ArrayList<WellknownClassJudgeRule> copiedRules = new ArrayList<WellknownClassJudgeRule>(this.rules);
        return copiedRules.iterator();
    }

    public synchronized WellknownClassJudgeRule[] getRules() {
        return this.rules.toArray(new WellknownClassJudgeRule[this.rules.size()]);
    }

    public void add(WellknownClassJudgeRule rule) {
        if (!this.rules.contains(rule)) {
            this.rules.add(rule);
        }
    }

    private boolean checkSystemClass(String className) {
        FullyClassName name = new FullyClassName(className);
        if (this.isMatch(name, true)) {
            return false;
        }
        return this.isMatch(name, false);
    }

    private boolean isMatch(FullyClassName name, boolean excludeFlag) {
        for (WellknownClassJudgeRule s : this.rules) {
            if (s.isExclude() != excludeFlag) continue;
            boolean flag = false;
            String partName = name.getFullyName();
            if (s.getMatchPartType() == WellknownClassJudgeRule.MatchPartType.CLASS_NAME) {
                partName = name.getClassName();
            } else if (s.getMatchPartType() == WellknownClassJudgeRule.MatchPartType.PACKAGE_NAME) {
                partName = name.getPackageName();
            }
            switch (s.getMatchType()) {
                case PREFIX: {
                    flag = partName.startsWith(s.getPattern());
                    break;
                }
                case SUFFIX: {
                    flag = partName.endsWith(s.getPattern());
                    break;
                }
                case EXACT: {
                    flag = partName.equals(s.getPattern());
                    break;
                }
                case NOT_MATCH: {
                    boolean bl = flag = !partName.equals(s.getPattern());
                }
            }
            if (!flag) continue;
            return flag;
        }
        return false;
    }

    private boolean checkSystemMethod(int access, String methodName, String signature) {
        if (methodName.equals("main")) {
            return signature.equals("([Ljava/lang/String;)V") && this.checkAccess(access, 1);
        }
        if (methodName.equals("<clinit>")) {
            return signature.equals("()V") && this.checkAccess(access, 8);
        }
        if (methodName.equals("<init>")) {
            return !this.checkAccess(access, 8);
        }
        return false;
    }

    private boolean checkSystemField(int access, String fieldName, String signature) {
        if (fieldName.equals("serialVersionUID")) {
            return this.checkAccess(access, 8) && this.checkAccess(access, 16) && signature.equals("J");
        }
        return false;
    }

    public boolean isWellKnownClass(String className) {
        return this.checkSystemClass(className);
    }

    public boolean isSystemMethod(int access, String methodName, String signature) {
        return this.checkSystemMethod(access, methodName, signature);
    }

    public boolean isSystemField(int access, String fieldName, String signature) {
        return this.checkSystemField(access, fieldName, signature);
    }

    private boolean checkAccess(int access, int code) {
        return (access & code) == code;
    }
}

