/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.stigmata.utils;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class LocalizedDescriptionManager {
    private Map<Locale, ResourceBundle> resources = new HashMap<Locale, ResourceBundle>();
    private static LocalizedDescriptionManager manager = new LocalizedDescriptionManager();

    private LocalizedDescriptionManager() {
    }

    public String getDisplayType(Locale locale, String type) {
        return this.getDisplayType(locale, type, ServiceCategory.birthmark);
    }

    public String getDisplayType(Locale locale, String type, ServiceCategory category) {
        try {
            return this.getBundle(locale).getString(category.name() + "." + type + ".display.type");
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    public String getDescription(Locale locale, String birthmarkType) {
        return this.getDescription(locale, birthmarkType, ServiceCategory.birthmark);
    }

    public String getDescription(Locale locale, String type, ServiceCategory category) {
        try {
            return this.getBundle(locale).getString(category.name() + "." + type + ".description");
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    private ResourceBundle getBundle(Locale locale) {
        ResourceBundle bundle = this.resources.get(locale);
        if (bundle == null) {
            bundle = ResourceBundle.getBundle("resources.description", locale);
            this.resources.put(locale, bundle);
        }
        return bundle;
    }

    public static LocalizedDescriptionManager getInstance() {
        return manager;
    }

    public static enum ServiceCategory {
        comparator,
        extractor,
        birthmark,
        formatter,
        filter;

    }
}

