/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.stigmata.ui.swing.filter;

import java.awt.GridLayout;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import jp.sourceforge.stigmata.ComparisonPairFilter;
import jp.sourceforge.stigmata.filter.FilterTarget;
import jp.sourceforge.stigmata.filter.TotalElementCountComparisonPairFilter;
import jp.sourceforge.stigmata.filter.TotalElementCountComparisonPairFilterService;
import jp.sourceforge.stigmata.spi.ComparisonPairFilterSpi;
import jp.sourceforge.stigmata.ui.swing.StigmataFrame;
import jp.sourceforge.stigmata.ui.swing.filter.AbstractComparisonPairFilterComponentService;
import jp.sourceforge.stigmata.ui.swing.filter.ComparisonPairFilterPane;

public class TotalElementCountComparisonPairFilterComponentService
extends AbstractComparisonPairFilterComponentService {
    @Override
    public ComparisonPairFilterPane createComponent(StigmataFrame frame, ComparisonPairFilterSpi service) {
        return new Pane(frame, service);
    }

    @Override
    public String getFilterName() {
        return "totalelementcount";
    }

    @Override
    public ComparisonPairFilterSpi getComparisonPairFilterService() {
        return new TotalElementCountComparisonPairFilterService();
    }

    private static class Pane
    extends ComparisonPairFilterPane {
        private static final long serialVersionUID = 8912037614500713027L;
        private ComparisonPairFilterSpi service;
        private JComboBox criterionType;
        private JTextField threshold;
        private JComboBox targetType;

        public Pane(StigmataFrame frame, ComparisonPairFilterSpi service) {
            super(frame);
            this.service = service;
            this.initLayouts();
        }

        @Override
        public String[] getErrors() {
            ArrayList<String> errors = new ArrayList<String>();
            if (this.threshold.getText().trim().equals("")) {
                errors.add(this.getMessages().get("error.empty.threshold"));
            }
            try {
                int v = Integer.parseInt(this.threshold.getText());
                if (v < 0) {
                    errors.add(this.getMessages().format("error.negative.value", new Object[]{v}));
                }
            }
            catch (NumberFormatException e) {
                errors.add(this.getMessages().format("error.invalid.format.integer", new Object[]{this.threshold.getText()}));
            }
            return errors.toArray(new String[errors.size()]);
        }

        @Override
        public ComparisonPairFilter getFilter() {
            try {
                TotalElementCountComparisonPairFilter filter = new TotalElementCountComparisonPairFilter(this.service);
                filter.setCriterion(this.getCriterion((String)this.criterionType.getSelectedItem()));
                filter.setThreshold(Integer.parseInt(this.threshold.getText()));
                filter.setTarget(this.getTarget((String)this.targetType.getSelectedItem()));
                return filter;
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }

        @Override
        public void resetComponents() {
            this.threshold.setText("");
            this.criterionType.setSelectedIndex(0);
            this.targetType.setSelectedItem(this.getDisplayTarget(FilterTarget.BOTH_TARGETS));
        }

        @Override
        public void setFilter(ComparisonPairFilter cpf) {
            TotalElementCountComparisonPairFilter filter = (TotalElementCountComparisonPairFilter)cpf;
            this.criterionType.setSelectedItem(this.getDisplayCriterion(filter.getCriterion()));
            this.threshold.setText(String.valueOf(filter.getThreshold()));
            this.targetType.setSelectedItem(this.getDisplayTarget(filter.getTarget()));
        }

        private void initLayouts() {
            JLabel label = new JLabel(this.getMessages().get("filter.totalelementcount.label"));
            this.threshold = new JTextField();
            this.criterionType = this.createCriteriaBox(TotalElementCountComparisonPairFilter.getValidCriteria());
            this.targetType = this.createTargetBox();
            this.setLayout(new GridLayout(4, 1));
            this.add(label);
            this.add(this.targetType);
            this.add(this.criterionType);
            this.add(this.threshold);
        }
    }
}

