/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.stigmata.ui.swing;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import jp.sourceforge.stigmata.BirthmarkSet;
import jp.sourceforge.stigmata.ui.swing.BirthmarkTreeNode;
import jp.sourceforge.stigmata.ui.swing.StigmataFrame;

public class BirthmarkTree
extends JTree {
    private static final long serialVersionUID = 68345692177534765L;
    private List<BirthmarkSet> birthmarks = new ArrayList<BirthmarkSet>();
    private DefaultTreeModel model = (DefaultTreeModel)this.getModel();
    private DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.model.getRoot();

    public BirthmarkTree(StigmataFrame frame) {
        super(new DefaultTreeModel(new DefaultMutableTreeNode(frame.getMessages().get("birthmarktree.root.label"), true)));
    }

    public BirthmarkTree(StigmataFrame frame, BirthmarkSet[] birthmarks) {
        this(frame);
        this.setBirthmarks(birthmarks);
    }

    public synchronized BirthmarkSet[] getBirthmarkHolders() {
        return this.birthmarks.toArray(new BirthmarkSet[this.birthmarks.size()]);
    }

    public void setBirthmarks(BirthmarkSet[] sets) {
        this.birthmarks.clear();
        for (BirthmarkSet set : sets) {
            this.birthmarks.add(set);
            this.root.add(new BirthmarkTreeNode(set));
        }
        this.expandRow(0);
    }
}

