/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.stigmata.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jp.sourceforge.stigmata.BirthmarkEnvironment;
import jp.sourceforge.stigmata.birthmarks.BirthmarkService;
import jp.sourceforge.stigmata.spi.BirthmarkComparatorSpi;
import jp.sourceforge.stigmata.spi.BirthmarkExtractorSpi;
import jp.sourceforge.stigmata.spi.BirthmarkSpi;
import jp.sourceforge.stigmata.spi.ServiceProvider;
import jp.sourceforge.stigmata.ui.swing.BirthmarkServiceListCellRenderer;
import jp.sourceforge.stigmata.ui.swing.BirthmarkServiceListener;
import jp.sourceforge.stigmata.ui.swing.GUIUtility;
import jp.sourceforge.stigmata.ui.swing.StigmataFrame;
import jp.sourceforge.talisman.i18n.Messages;

public class BirthmarkDefinitionPane
extends JPanel {
    private static final long serialVersionUID = 3932637653297802978L;
    private StigmataFrame stigmata;
    private DefaultListModel model;
    private InformationPane information;
    private JList serviceList;
    private JButton newService;
    private JButton removeService;
    private List<BirthmarkSpi> addedService = new ArrayList<BirthmarkSpi>();
    private List<BirthmarkServiceListener> listeners = new ArrayList<BirthmarkServiceListener>();

    public BirthmarkDefinitionPane(StigmataFrame stigmata) {
        this.stigmata = stigmata;
        this.initLayouts();
        this.initData();
        this.updateView();
    }

    public void addBirthmarkServiceListener(BirthmarkServiceListener listener) {
        this.listeners.add(listener);
    }

    public void removeBirthmarkServiceListener(BirthmarkServiceListener listener) {
        this.listeners.remove(listener);
    }

    public void reset() {
        for (BirthmarkSpi service : this.addedService) {
            this.model.removeElement(service);
        }
    }

    public void updateEnvironment(BirthmarkEnvironment environment) {
        for (BirthmarkSpi service : this.addedService) {
            if (environment.getService(service.getType()) != null) continue;
            if (service instanceof BirthmarkService) {
                ((BirthmarkService)service).setBirthmarkEnvironment(environment);
            }
            environment.addService(service);
        }
    }

    private void initData() {
        this.information.initData();
        this.model.addElement(this.stigmata.getMessages().get("newservice.definition.label"));
        for (BirthmarkSpi service : this.stigmata.getEnvironment().findServices()) {
            this.model.addElement(service);
        }
    }

    private void initLayouts() {
        Messages messages = this.stigmata.getMessages();
        JPanel panel = new JPanel(new BorderLayout());
        this.model = new DefaultListModel();
        this.serviceList = new JList(this.model);
        this.serviceList.setCellRenderer(new BirthmarkServiceListCellRenderer(new Dimension(250, 20), 60));
        JScrollPane scroll = new JScrollPane(this.serviceList);
        scroll.setBorder(new TitledBorder(messages.get("servicelist.border")));
        this.serviceList.setToolTipText(messages.get("servicelist.tooltip"));
        panel.add((Component)scroll, "West");
        this.information = new InformationPane(this.stigmata, this);
        panel.add((Component)this.information, "Center");
        Box buttonPanel = Box.createHorizontalBox();
        this.newService = GUIUtility.createButton(messages, "newservice");
        this.removeService = GUIUtility.createButton(messages, "removeservice");
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.newService);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.removeService);
        buttonPanel.add(Box.createHorizontalGlue());
        this.setLayout(new BorderLayout());
        this.add((Component)panel, "Center");
        this.add((Component)buttonPanel, "South");
        this.removeService.setEnabled(false);
        this.serviceList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                BirthmarkDefinitionPane.this.listValueChanged(e);
            }
        });
        this.newService.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BirthmarkDefinitionPane.this.addNewService();
            }
        });
        this.removeService.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BirthmarkDefinitionPane.this.removeService();
            }
        });
    }

    private void removeService() {
        BirthmarkSpi service;
        int index = this.serviceList.getSelectedIndex();
        if (index > 0 && (service = (BirthmarkSpi)this.model.getElementAt(index)) != null && service.isUserDefined()) {
            this.model.remove(index);
            for (BirthmarkServiceListener listener : this.listeners) {
                listener.serviceRemoved(service);
            }
        }
        this.stigmata.setNeedToSaveSettings(true);
        this.updateView();
    }

    private void addNewService() {
        BirthmarkService service = this.information.createService();
        this.model.addElement(service);
        this.addedService.add(service);
        for (BirthmarkServiceListener listener : this.listeners) {
            listener.serviceAdded(service);
        }
        this.stigmata.setNeedToSaveSettings(true);
        this.updateView();
    }

    private void listValueChanged(ListSelectionEvent e) {
        int index = this.serviceList.getSelectedIndex();
        if (index > 0) {
            BirthmarkSpi service = (BirthmarkSpi)this.model.getElementAt(index);
            if (service != null) {
                this.information.setService(service);
            }
        } else if (index == 0) {
            this.information.clear();
        }
        this.updateView();
    }

    private void updateView() {
        int index = this.serviceList.getSelectedIndex();
        ListModel model = this.serviceList.getModel();
        BirthmarkSpi service = null;
        if (index > 0) {
            service = (BirthmarkSpi)model.getElementAt(index);
        }
        this.newService.setEnabled((index <= 0 || service.isUserDefined()) && this.information.isAvailableService() && this.isAvailableServiceName(this.information.getType()));
        this.removeService.setEnabled(index > 0 && service.isUserDefined());
        this.information.setEnabled(index <= 0 || service.isUserDefined());
    }

    private boolean isAvailableServiceName(String name) {
        for (BirthmarkSpi service : this.addedService) {
            if (!service.getType().equals(name)) continue;
            return false;
        }
        return true;
    }

    private static class InformationPane
    extends JPanel {
        private static final long serialVersionUID = 37906542932362L;
        private StigmataFrame stigmata;
        private BirthmarkDefinitionPane thisPane;
        private JTextField type;
        private JTextField displayType;
        private JTextArea description;
        private JComboBox extractor;
        private JComboBox comparator;
        private JCheckBox expert;
        private JCheckBox userDefined;

        public InformationPane(StigmataFrame stigmata, BirthmarkDefinitionPane thisPane) {
            this.stigmata = stigmata;
            this.thisPane = thisPane;
            this.initLayouts();
        }

        public String getType() {
            return this.type.getText();
        }

        @Override
        public void setEnabled(boolean flag) {
            super.setEnabled(flag);
            this.type.setEnabled(flag);
            this.displayType.setEnabled(flag);
            this.description.setEnabled(flag);
            this.extractor.setEnabled(flag);
            this.comparator.setEnabled(flag);
        }

        public BirthmarkService createService() {
            BirthmarkService service = new BirthmarkService();
            service.setType(this.type.getText());
            service.setDisplayType(this.displayType.getText());
            service.setDescription(this.description.getText());
            service.setExtractorClassName(this.extractor.getSelectedItem().toString());
            service.setComparatorClassName(this.comparator.getSelectedItem().toString());
            service.setUserDefined(true);
            return service;
        }

        public void clear() {
            this.type.setText("");
            this.displayType.setText("");
            this.description.setText("");
            this.extractor.getModel().setSelectedItem(null);
            this.comparator.getModel().setSelectedItem(null);
            this.userDefined.setSelected(true);
            this.expert.setSelected(true);
        }

        public boolean isAvailableService() {
            String newType = this.type.getText();
            Object selectedExtractor = this.extractor.getSelectedItem();
            String extractorClass = "";
            if (selectedExtractor != null) {
                extractorClass = selectedExtractor.toString();
            }
            Object selectedComparator = this.comparator.getSelectedItem();
            String comparatorClass = "";
            if (selectedComparator != null) {
                comparatorClass = selectedComparator.toString();
            }
            BirthmarkEnvironment environment = this.stigmata.getEnvironment();
            boolean flag = newType.length() > 0 && this.displayType.getText().length() > 0 && extractorClass.length() > 0 && comparatorClass.length() > 0;
            flag = flag && environment.getService(newType) == null;
            flag = flag && environment.getClasspathContext().findEntry(extractorClass) != null && environment.getClasspathContext().findEntry(comparatorClass) != null;
            return flag;
        }

        public void setService(BirthmarkSpi service) {
            this.type.setText(service.getType());
            this.displayType.setText(service.getDisplayType());
            this.description.setText(service.getDefaultDescription());
            this.selectComboBoxItem(this.extractor, service.getExtractorClassName());
            this.selectComboBoxItem(this.comparator, service.getComparatorClassName());
            this.userDefined.setSelected(service.isUserDefined());
            this.expert.setSelected(service.isExpert());
            this.setEnabled(service.isUserDefined());
        }

        public void initData() {
            ServiceProvider service;
            this.comparator.addItem("");
            Iterator<ServiceProvider> i = this.stigmata.getEnvironment().lookupProviders(BirthmarkComparatorSpi.class);
            while (i.hasNext()) {
                service = i.next();
                this.comparator.addItem(service.getComparatorClassName());
            }
            this.extractor.addItem("");
            i = this.stigmata.getEnvironment().lookupProviders(BirthmarkExtractorSpi.class);
            while (i.hasNext()) {
                service = (BirthmarkExtractorSpi)i.next();
                this.extractor.addItem(service.getExtractorClassName());
            }
        }

        private void selectComboBoxItem(JComboBox box, String item) {
            box.getModel().setSelectedItem(item);
        }

        private void initLayouts() {
            Messages messages = this.stigmata.getMessages();
            this.type = new JTextField();
            this.displayType = new JTextField();
            this.extractor = new JComboBox();
            this.comparator = new JComboBox();
            this.expert = new JCheckBox(messages.get("define.expert.label"));
            this.userDefined = new JCheckBox(messages.get("define.userdef.label"));
            this.description = new JTextArea();
            JScrollPane scroll = new JScrollPane(this.description);
            this.type.setColumns(10);
            this.displayType.setColumns(20);
            this.description.setColumns(40);
            this.description.setRows(10);
            JPanel typePane = new JPanel(new BorderLayout());
            JPanel displayTypePane = new JPanel(new BorderLayout());
            typePane.add((Component)this.type, "Center");
            displayTypePane.add((Component)this.displayType, "Center");
            JPanel box1 = new JPanel(new BorderLayout());
            box1.add((Component)typePane, "West");
            box1.add((Component)displayTypePane, "Center");
            Box box2 = Box.createHorizontalBox();
            box2.add(Box.createHorizontalGlue());
            box2.add(this.expert);
            box2.add(Box.createHorizontalGlue());
            box2.add(this.userDefined);
            box2.add(Box.createHorizontalGlue());
            JPanel extractorPane = new JPanel(new BorderLayout());
            extractorPane.add((Component)this.extractor, "Center");
            JPanel comparatorPane = new JPanel(new BorderLayout());
            comparatorPane.add((Component)this.comparator, "Center");
            Box panel = Box.createVerticalBox();
            panel.add(box1);
            panel.add(extractorPane);
            panel.add(comparatorPane);
            panel.add(box2);
            this.setLayout(new BorderLayout());
            this.add((Component)panel, "North");
            this.add((Component)scroll, "Center");
            GUIUtility.decorateJComponent(messages, typePane, "define.type");
            GUIUtility.decorateJComponent(messages, displayTypePane, "define.displaytype");
            GUIUtility.decorateJComponent(messages, scroll, "define.description");
            GUIUtility.decorateJComponent(messages, extractorPane, "define.extractor");
            GUIUtility.decorateJComponent(messages, comparatorPane, "define.comparator");
            GUIUtility.decorateJComponent(messages, this.expert, "define.expert");
            GUIUtility.decorateJComponent(messages, this.userDefined, "define.userdef");
            this.userDefined.setEnabled(false);
            this.expert.setEnabled(false);
            this.userDefined.setSelected(true);
            this.expert.setSelected(true);
            this.extractor.setEditable(true);
            this.comparator.setEditable(true);
            DocumentListener listener = new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    InformationPane.this.thisPane.updateView();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    InformationPane.this.thisPane.updateView();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    InformationPane.this.thisPane.updateView();
                }
            };
            this.type.getDocument().addDocumentListener(listener);
            this.displayType.getDocument().addDocumentListener(listener);
            this.description.getDocument().addDocumentListener(listener);
            ItemListener itemListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    InformationPane.this.thisPane.updateView();
                }
            };
            this.comparator.addItemListener(itemListener);
            this.extractor.addItemListener(itemListener);
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    InformationPane.this.thisPane.updateView();
                }
            };
            this.comparator.getEditor().addActionListener(actionListener);
            this.extractor.getEditor().addActionListener(actionListener);
        }
    }
}

