/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.stigmata.result;

import java.io.File;
import jp.sourceforge.stigmata.BirthmarkContext;
import jp.sourceforge.stigmata.BirthmarkEnvironment;
import jp.sourceforge.stigmata.BirthmarkStoreTarget;
import jp.sourceforge.stigmata.ExtractionResultSet;
import jp.sourceforge.stigmata.result.AbstractExtractionResultSet;
import jp.sourceforge.stigmata.result.XmlFileExtractionResultSet;
import jp.sourceforge.stigmata.result.history.ExtractedBirthmarkHistory;
import jp.sourceforge.stigmata.result.history.XmlFileExtractedBirthmarkHistory;
import jp.sourceforge.stigmata.spi.ExtractedBirthmarkSpi;

public class XmlFileExtractedBirthmarkService
implements ExtractedBirthmarkSpi {
    private File defaultBaseDirectory = new File(BirthmarkEnvironment.getStigmataHome(), "extracted_birthmarks");

    @Override
    public ExtractionResultSet createResultSet(BirthmarkContext context) {
        return this.createResultSet(context, this.defaultBaseDirectory);
    }

    public ExtractionResultSet createResultSet(BirthmarkContext context, File base) {
        return new XmlFileExtractionResultSet(context, new File(base, AbstractExtractionResultSet.generateId()));
    }

    @Override
    public ExtractedBirthmarkHistory getHistory(String parameter) {
        File file = this.defaultBaseDirectory;
        if (parameter != null) {
            file = new File(parameter);
        }
        if (!file.exists()) {
            file.mkdirs();
        }
        return new XmlFileExtractedBirthmarkHistory(file);
    }

    @Override
    public ExtractionResultSet getResultSet(String id) {
        return new XmlFileExtractionResultSet(new File(id));
    }

    @Override
    public BirthmarkStoreTarget getTarget() {
        return BirthmarkStoreTarget.XMLFILE;
    }
}

