/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.stigmata.printer.csv;

import java.io.PrintWriter;
import java.util.Iterator;
import jp.sourceforge.stigmata.Birthmark;
import jp.sourceforge.stigmata.BirthmarkElement;
import jp.sourceforge.stigmata.BirthmarkSet;
import jp.sourceforge.stigmata.ExtractionResultSet;
import jp.sourceforge.stigmata.ExtractionTarget;
import jp.sourceforge.stigmata.printer.AbstractExtractionResultSetPrinter;

public class ExtractionResultSetCsvPrinter
extends AbstractExtractionResultSetPrinter {
    @Override
    public void printResult(PrintWriter out, ExtractionResultSet ers) {
        this.printHeader(out);
        Iterator<BirthmarkSet> i = ers.birthmarkSets(ExtractionTarget.TARGET_BOTH);
        while (i.hasNext()) {
            this.printBirthmarkSet(out, i.next());
        }
        this.printFooter(out);
    }

    protected void printBirthmarkSet(PrintWriter out, BirthmarkSet holder) {
        for (String type : holder.getBirthmarkTypes()) {
            out.print(holder.getName());
            out.print(",");
            out.print(holder.getLocation());
            Birthmark birthmark = holder.getBirthmark(type);
            out.print(",");
            out.print(birthmark.getType());
            Iterator<BirthmarkElement> elements = birthmark.iterator();
            while (elements.hasNext()) {
                out.print(",");
                out.print(elements.next());
            }
            out.println();
        }
    }
}

