/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.stigmata.printer.csv;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import jp.sourceforge.stigmata.ComparisonPair;
import jp.sourceforge.stigmata.ComparisonResultSet;
import jp.sourceforge.stigmata.printer.AbstractComparisonResultSetPrinter;
import jp.sourceforge.stigmata.result.CertainPairComparisonResultSet;

public class ComparisonResultSetCsvPrinter
extends AbstractComparisonResultSetPrinter {
    @Override
    public void printResult(PrintWriter out, ComparisonResultSet resultset) {
        if (resultset instanceof CertainPairComparisonResultSet) {
            this.printResultImpl(out, (CertainPairComparisonResultSet)resultset);
        } else {
            this.printResultImpl(out, resultset);
        }
    }

    private void printResultImpl(PrintWriter out, CertainPairComparisonResultSet resultset) {
        for (ComparisonPair pair : resultset) {
            out.print(pair.getTarget1().getName());
            out.print(",");
            out.print(pair.getTarget1().getName());
            out.print(",");
            out.println(pair.calculateSimilarity());
        }
    }

    private void printResultImpl(PrintWriter out, ComparisonResultSet resultset) {
        LinkedHashMap<String, HashMap<String, Double>> map = new LinkedHashMap<String, HashMap<String, Double>>();
        ArrayList<String> names = new ArrayList<String>();
        for (ComparisonPair comparisonPair : resultset) {
            HashMap<String, Double> val = (HashMap<String, Double>)map.get(comparisonPair.getTarget1().getName());
            if (val == null) {
                val = new HashMap<String, Double>();
            }
            val.put(comparisonPair.getTarget2().getName(), new Double(comparisonPair.calculateSimilarity()));
            if (!names.contains(comparisonPair.getTarget2().getName())) {
                names.add(comparisonPair.getTarget2().getName());
            }
            map.put(comparisonPair.getTarget1().getName(), val);
        }
        for (String string : names) {
            out.print(",");
            out.print(string);
        }
        out.println();
        for (Map.Entry entry : map.entrySet()) {
            out.print((String)entry.getKey());
            Map element = (Map)entry.getValue();
            for (String name : names) {
                out.print(",");
                Double v = (Double)element.get(name);
                if (v == null) continue;
                out.print(v);
            }
            out.println();
        }
        out.flush();
    }
}

