/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.stigmata.command;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.stigmata.BirthmarkContext;
import jp.sourceforge.stigmata.BirthmarkEnvironment;
import jp.sourceforge.stigmata.Stigmata;
import jp.sourceforge.stigmata.birthmarks.BirthmarkService;
import jp.sourceforge.stigmata.command.AbstractStigmataCommand;
import jp.sourceforge.stigmata.spi.BirthmarkSpi;
import jp.sourceforge.stigmata.utils.ConfigFileExporter;

@Deprecated
public class UninstallCommand
extends AbstractStigmataCommand {
    @Override
    public boolean isAvailableArguments(String[] args) {
        return args.length > 0;
    }

    @Override
    public String getCommandString() {
        return "uninstall";
    }

    @Override
    public void perform(Stigmata stigmata, BirthmarkContext context, String[] args) {
        File pluginsDir = new File(BirthmarkEnvironment.getStigmataHome(), "plugins");
        BirthmarkEnvironment env = context.getEnvironment();
        boolean removeServiceInConfigFile = false;
        for (int i = 0; i < args.length; ++i) {
            BirthmarkSpi service = env.getService(args[i]);
            if (service instanceof BirthmarkService) {
                env.removeService(args[i]);
                removeServiceInConfigFile = true;
                continue;
            }
            String fileName = this.getPluginFileNameOfService(context, service);
            if (fileName == null) continue;
            File pluginFile = new File(pluginsDir, fileName);
            pluginFile.renameTo(new File(pluginFile.getParentFile(), pluginFile.getName() + ".back"));
        }
        if (removeServiceInConfigFile) {
            this.updateConfigFile(env);
        }
    }

    private void updateConfigFile(BirthmarkEnvironment env) {
        File configFile = new File(BirthmarkEnvironment.getStigmataHome(), "stigmata.xml");
        try {
            new ConfigFileExporter(env).export(new PrintWriter(new FileWriter(configFile)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getPluginFileNameOfService(BirthmarkContext context, BirthmarkSpi service) {
        Pattern pattern;
        Matcher matcher;
        Class<?> serviceClass = service.getClass();
        URL location = serviceClass.getResource("/" + serviceClass.getName().replace('.', '/') + ".class");
        if (location != null && (matcher = (pattern = Pattern.compile("jar:(.*)/plugins/(.*.jar)!([a-zA-Z0-9$/.]+.class)")).matcher(location.toString())).matches()) {
            try {
                URL homeLocation = new File(BirthmarkEnvironment.getStigmataHome()).toURI().toURL();
                String matchedLocation = matcher.group(1) + "/";
                if (matchedLocation.equals(homeLocation.toString())) {
                    return matcher.group(2);
                }
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

