/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.stigmata.command;

import java.util.HashMap;
import java.util.Map;
import jp.sourceforge.stigmata.StigmataCommand;
import jp.sourceforge.stigmata.command.CompareCommand;
import jp.sourceforge.stigmata.command.ExportConfigCommand;
import jp.sourceforge.stigmata.command.ExtractCommand;
import jp.sourceforge.stigmata.command.GuiCommand;
import jp.sourceforge.stigmata.command.InstallCommand;
import jp.sourceforge.stigmata.command.LicenseCommand;
import jp.sourceforge.stigmata.command.ListBirthmarksCommand;
import jp.sourceforge.stigmata.command.VersionCommand;

public class StigmataCommandFactory {
    private static final StigmataCommandFactory factory = new StigmataCommandFactory();
    private Map<String, StigmataCommand> commands = new HashMap<String, StigmataCommand>();

    private StigmataCommandFactory() {
        this.commands.put("compare", new CompareCommand());
        this.commands.put("export-config", new ExportConfigCommand());
        this.commands.put("extract", new ExtractCommand());
        this.commands.put("gui", new GuiCommand());
        this.commands.put("install", new InstallCommand());
        this.commands.put("license", new LicenseCommand());
        this.commands.put("list-birthmarks", new ListBirthmarksCommand());
        this.commands.put("version", new VersionCommand());
    }

    public void registerCommand(String commandString, StigmataCommand command) {
        this.commands.put(commandString, command);
    }

    public static StigmataCommandFactory getInstance() {
        return factory;
    }

    public StigmataCommand getCommand(String command) {
        return this.commands.get(command);
    }
}

