/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.stigmata.birthmarks.uc;

import jp.sourceforge.stigmata.Birthmark;
import jp.sourceforge.stigmata.BirthmarkContext;
import jp.sourceforge.stigmata.BirthmarkElement;
import jp.sourceforge.stigmata.birthmarks.BirthmarkExtractVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodAdapter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureWriter;

public class UsedClassesBirthmarkExtractVisitor
extends BirthmarkExtractVisitor {
    public UsedClassesBirthmarkExtractVisitor(ClassVisitor visitor, Birthmark birthmark, BirthmarkContext context) {
        super(visitor, birthmark, context);
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.addSignatureClass(signature);
        if (this.getEnvironment().getWellknownClassManager().isWellKnownClass(superName)) {
            this.add(superName);
        }
        for (String i : interfaces) {
            if (!this.getEnvironment().getWellknownClassManager().isWellKnownClass(i)) continue;
            this.add(i);
        }
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        FieldVisitor visitor = super.visitField(access, name, desc, signature, value);
        this.addDescriptor(desc);
        this.addSignatureClass(signature);
        return visitor;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (exceptions != null) {
            for (String exception : exceptions) {
                if (!this.getEnvironment().getWellknownClassManager().isWellKnownClass(exception)) continue;
                this.add(exception);
            }
        }
        this.addMethodDescriptor(desc);
        this.addSignatureClass(signature);
        MethodVisitor visitor = super.visitMethod(access, name, desc, signature, exceptions);
        return new MethodAdapter(visitor){

            @Override
            public void visitTypeInsn(int opcode, String desc) {
                Type type = Type.getType("L" + desc + ";");
                if (UsedClassesBirthmarkExtractVisitor.this.checkType(type)) {
                    UsedClassesBirthmarkExtractVisitor.this.add(desc);
                }
                super.visitTypeInsn(opcode, desc);
            }

            @Override
            public void visitTryCatchBlock(Label start, Label end, Label handle, String desc) {
                Type type = Type.getType("L" + desc + ";");
                if (UsedClassesBirthmarkExtractVisitor.this.checkType(type)) {
                    UsedClassesBirthmarkExtractVisitor.this.add(UsedClassesBirthmarkExtractVisitor.this.getType(type));
                }
                super.visitTryCatchBlock(start, end, handle, desc);
            }

            @Override
            public void visitMultiANewArrayInsn(String desc, int dims) {
                Type type = Type.getType(desc);
                if (UsedClassesBirthmarkExtractVisitor.this.checkType(type)) {
                    UsedClassesBirthmarkExtractVisitor.this.add(UsedClassesBirthmarkExtractVisitor.this.getType(type));
                }
                super.visitMultiANewArrayInsn(desc, dims);
            }

            @Override
            public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
                if (UsedClassesBirthmarkExtractVisitor.this.checkType(Type.getType(desc))) {
                    UsedClassesBirthmarkExtractVisitor.this.add(desc);
                }
                UsedClassesBirthmarkExtractVisitor.this.addSignatureClass(signature);
                super.visitLocalVariable(name, desc, signature, start, end, index);
            }

            @Override
            public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                if (UsedClassesBirthmarkExtractVisitor.this.getEnvironment().getWellknownClassManager().isWellKnownClass(owner)) {
                    UsedClassesBirthmarkExtractVisitor.this.add(owner);
                }
                UsedClassesBirthmarkExtractVisitor.this.addDescriptor(desc);
                super.visitFieldInsn(opcode, owner, name, desc);
            }

            @Override
            public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                String className = UsedClassesBirthmarkExtractVisitor.this.normalize(owner);
                if (UsedClassesBirthmarkExtractVisitor.this.getEnvironment().getWellknownClassManager().isWellKnownClass(className)) {
                    UsedClassesBirthmarkExtractVisitor.this.add(className);
                }
                UsedClassesBirthmarkExtractVisitor.this.addMethodDescriptor(desc);
                super.visitMethodInsn(opcode, owner, name, desc);
            }
        };
    }

    private void addSignatureClass(String signature) {
        if (signature != null) {
            SignatureReader in = new SignatureReader(signature);
            SignatureWriter writer = new SignatureWriter(){

                @Override
                public void visitClassType(String classType) {
                    if (UsedClassesBirthmarkExtractVisitor.this.getEnvironment().getWellknownClassManager().isWellKnownClass(classType)) {
                        UsedClassesBirthmarkExtractVisitor.this.add(classType);
                    }
                }
            };
            in.accept(writer);
        }
    }

    private void addMethodDescriptor(String desc) {
        Type returnType = Type.getReturnType(desc);
        Type[] args = Type.getArgumentTypes(desc);
        if (this.checkType(returnType)) {
            this.add(this.getType(returnType));
        }
        for (Type arg : args) {
            if (!this.checkType(arg)) continue;
            this.add(this.getType(arg));
        }
    }

    private void addDescriptor(String desc) {
        Type type = Type.getType(desc);
        if (this.checkType(type)) {
            this.add(desc);
        }
    }

    private String getType(Type type) {
        if (type.getSort() == 9) {
            while (type.getSort() != 9) {
                type = type.getElementType();
            }
        }
        if (type.getSort() == 10) {
            return this.normalize(type.getClassName());
        }
        return null;
    }

    private boolean checkType(Type type) {
        if (type.getSort() == 9) {
            while (type.getSort() != 9) {
                type = type.getElementType();
            }
        }
        if (type.getSort() == 10) {
            String className = type.getClassName();
            if (this.getEnvironment().getWellknownClassManager().isWellKnownClass(className)) {
                return true;
            }
        }
        return false;
    }

    private String normalize(String name) {
        if (name.startsWith("L") && name.endsWith(";")) {
            name = name.substring(1, name.length() - 1);
        }
        name = name.replace('/', '.');
        return name;
    }

    private void add(String name) {
        this.addElement(new BirthmarkElement(this.normalize(name)));
    }
}

