/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.stigmata.birthmarks.is;

import java.io.IOException;
import java.io.InputStream;
import jp.sourceforge.stigmata.Birthmark;
import jp.sourceforge.stigmata.BirthmarkContext;
import jp.sourceforge.stigmata.BirthmarkElementClassNotFoundException;
import jp.sourceforge.stigmata.BirthmarkExtractionFailedException;
import jp.sourceforge.stigmata.ExtractionUnit;
import jp.sourceforge.stigmata.birthmarks.AbstractBirthmarkExtractor;
import jp.sourceforge.stigmata.birthmarks.is.InheritanceStructureBirthmarkExtractVisitor;
import jp.sourceforge.stigmata.spi.BirthmarkSpi;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;

public class InheritanceStructureBirthmarkExtractor
extends AbstractBirthmarkExtractor {
    public InheritanceStructureBirthmarkExtractor(BirthmarkSpi spi) {
        super(spi);
    }

    public InheritanceStructureBirthmarkExtractor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Birthmark extract(Birthmark birthmark, InputStream in, BirthmarkContext context) throws BirthmarkExtractionFailedException {
        BirthmarkElementClassNotFoundException e = new BirthmarkElementClassNotFoundException();
        try {
            ClassReader reader = new ClassReader(in);
            ClassWriter writer = new ClassWriter(0);
            InheritanceStructureBirthmarkExtractVisitor visitor = new InheritanceStructureBirthmarkExtractVisitor(writer, birthmark, context);
            reader.accept(visitor, 0);
            if (!visitor.isSuccess()) {
                for (Throwable t : visitor.getCauses()) {
                    if (t instanceof ClassNotFoundException) {
                        e.addClassName(t.getMessage());
                        continue;
                    }
                    e.addCause(t);
                }
            }
            if (!e.isFailed()) return birthmark;
        }
        catch (IOException ee) {
            try {
                e.addCause(ee);
                if (!e.isFailed()) return birthmark;
            }
            catch (Throwable throwable) {
                if (!e.isFailed()) throw throwable;
                System.out.printf("fail: %s%n", e.getMessage());
                throw e;
            }
            System.out.printf("fail: %s%n", e.getMessage());
            throw e;
        }
        System.out.printf("fail: %s%n", e.getMessage());
        throw e;
    }

    @Override
    public ExtractionUnit[] getAcceptableUnits() {
        return new ExtractionUnit[]{ExtractionUnit.CLASS};
    }
}

