/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.stigmata.birthmarks.comparators;

import jp.sourceforge.stigmata.Birthmark;
import jp.sourceforge.stigmata.BirthmarkContext;
import jp.sourceforge.stigmata.BirthmarkElement;
import jp.sourceforge.stigmata.birthmarks.comparators.AbstractBirthmarkComparator;
import jp.sourceforge.stigmata.spi.BirthmarkSpi;

public class PlainBirthmarkComparator
extends AbstractBirthmarkComparator {
    public PlainBirthmarkComparator(BirthmarkSpi spi) {
        super(spi);
    }

    @Override
    public double compare(Birthmark b1, Birthmark b2, BirthmarkContext context) {
        if (!b1.getType().equals(b2.getType())) {
            return Double.NaN;
        }
        BirthmarkElement[] element1 = b1.getElements();
        BirthmarkElement[] element2 = b2.getElements();
        int len = element1.length + element2.length;
        int frac = 0;
        for (int i = 0; i < element1.length && i < element2.length; ++i) {
            if (!element1[i].equals(element2[i])) continue;
            frac += 2;
        }
        double similarity = (double)frac / (double)len;
        if (len == 0 && frac == 0) {
            similarity = 1.0;
        }
        return similarity;
    }

    @Override
    public int getCompareCount(Birthmark b1, Birthmark b2) {
        return b1.getElementCount() + b2.getElementCount();
    }
}

