/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.stigmata;

import jp.sourceforge.stigmata.Birthmark;
import jp.sourceforge.stigmata.BirthmarkComparator;
import jp.sourceforge.stigmata.BirthmarkContext;

public class ComparisonPairElement {
    private Birthmark birthmark1;
    private Birthmark birthmark2;
    private BirthmarkComparator comparator;
    private double similarity;
    private int compareCount = -1;

    public ComparisonPairElement(Birthmark birthmark1, Birthmark birthmark2, BirthmarkComparator comparator, BirthmarkContext context) {
        this.birthmark1 = birthmark1;
        this.birthmark2 = birthmark2;
        this.comparator = comparator;
        if (!birthmark1.getType().equals(birthmark2.getType())) {
            throw new IllegalArgumentException("birthmark type mismatch");
        }
        this.similarity = comparator.compare(birthmark1, birthmark2, context);
    }

    public synchronized int getComparisonCount() {
        if (this.compareCount < 0) {
            this.compareCount = this.comparator.getCompareCount(this.birthmark1, this.birthmark2);
        }
        return this.compareCount;
    }

    public String getType() {
        return this.birthmark1.getType();
    }

    public double getSimilarity() {
        return this.similarity;
    }
}

