package jp.naist.se.stigmata.reader;

/*
 * $Id: ClassFileArchive.java 20 2007-01-17 02:06:01Z tama3 $
 */

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;

/**
 * abstract presentation of class file archive's location.
 *
 * @author Haruaki TAMADA
 * @version $Revision: 20 $ $Date: 2007-01-17 11:06:01 +0900 (Wed, 17 Jan 2007) $
 */
public interface ClassFileArchive{
    public URL getLocation();

    public InputStream getInputStream(ClassFileEntry entry) throws IOException;

    public Iterator<ClassFileEntry> entries();

    public boolean hasEntry(String className);

    public ClassFileEntry getEntry(String className) throws ClassNotFoundException;
}
