package jp.naist.se.stigmata.birthmarks.smc;

/*
 * $Id: MethodCallBirthmarkElement.java 20 2007-01-17 02:06:01Z tama3 $
 */

import java.io.Serializable;

import jp.naist.se.stigmata.BirthmarkElement;

/**
 * 
 * @author Haruaki TAMADA
 * @version $Revision: 20 $ $Date: 2007-01-17 11:06:01 +0900 (Wed, 17 Jan 2007) $
 */
public class MethodCallBirthmarkElement extends BirthmarkElement implements Serializable {
    private static final long serialVersionUID = -3178451461780859954L;

    private String className;
    private String methodName;
    private String signature;

    public MethodCallBirthmarkElement(String className, String methodName, String signature) {
        super(className + "#" + methodName);

        this.className = className;
        this.methodName = methodName;
        this.signature = signature;
    }

    public String getClassName(){
        return className;
    }

    public String getMethodName(){
        return methodName;
    }

    public String getSignature(){
        return signature;
    }

    public Object getValue(){
        return getClassName() + "#" + getMethodName();
    }

    public boolean equals(Object o){
        boolean flag = false;
        if(o instanceof MethodCallBirthmarkElement){
            MethodCallBirthmarkElement mcbe = (MethodCallBirthmarkElement)o;

            flag = getClassName().equals(mcbe.getClassName()) &&
                getMethodName().equals(mcbe.getMethodName())  &&
                getSignature().equals(mcbe.getSignature());
        }

        return flag;
    }
}
