package jp.naist.se.stigmata;

/*
 * $Id: ComparisonPairElement.java 20 2007-01-17 02:06:01Z tama3 $
 */

/**
 * This class represents comparing two birthmarks.
 * @author  Haruaki TAMADA
 * @version  $Revision: 20 $ $Date: 2007-01-17 11:06:01 +0900 (Wed, 17 Jan 2007) $
 */
public class ComparisonPairElement{
    private Birthmark birthmark1;
    private Birthmark birthmark2;
    private BirthmarkComparator comparator;
    private double similarity;
    private int compareCount = -1;

    public ComparisonPairElement(Birthmark birthmark1, Birthmark birthmark2,
            BirthmarkComparator comparator){
        this.birthmark1 = birthmark1;
        this.birthmark2 = birthmark2;
        this.comparator = comparator;

        if(!birthmark1.getType().equals(birthmark2.getType())){
            throw new IllegalArgumentException("birthmark type mismatch");
        }
        // cached
        similarity = comparator.compare(birthmark1, birthmark2);
    }

    public synchronized int getComparisonCount(){
        // cached
        if(compareCount < 0){
            compareCount = comparator.getCompareCount(birthmark1, birthmark2);
        }
        return compareCount;
    }

    public String getType(){
        return birthmark1.getType();
    }

    /**
     * @return  similarity
     * @uml.property  name="similarity"
     */
    public double getSimilarity(){
        return similarity;
    }
}
