package jp.naist.se.stigmata;

/*
 * $Id: BirthmarkExtractor.java 20 2007-01-17 02:06:01Z tama3 $
 */

import java.io.IOException;
import java.io.InputStream;

/**
 * extract birthmarks from given Java bytecode stream.
 * 
 * @author Haruaki TAMADA
 * @version $Revision: 20 $ $Date: 2007-01-17 11:06:01 +0900 (Wed, 17 Jan 2007) $
 */
public interface BirthmarkExtractor{
    /**
     * extract birthmark given stream.
     */
    public Birthmark extract(InputStream in) throws IOException;

    /**
     * extract birthmark given byte array.
     */
    public Birthmark extract(byte[] bytecode) throws IOException;

    /**
     * extract birthmark given stream with given context.
     */
    public Birthmark extract(InputStream in, BirthmarkContext context) throws IOException;

    /**
     * extract birthmark given byte array with given context.
     */
    public Birthmark extract(byte[] bytecode, BirthmarkContext context) throws IOException;
}
