/*
 * Decompiled with CFR 0.152.
 */
package net.trialpc.sticktools.stemmer;

import net.trialpc.sticktools.stemmer.AbstractStemmer;

public class PorterStemmer
extends AbstractStemmer {
    private char[] buf;
    private int endOfStem;
    private int endOfTerm;

    @Override
    public String interpret(String term) {
        this.initialize(term);
        if (this.endOfTerm > 1) {
            this.step1();
            this.step2();
            this.step3();
            this.step4();
            this.step5();
            this.step6();
        }
        return new String(this.buf, 0, this.endOfTerm + 1);
    }

    private void initialize(String term) {
        this.buf = term.toCharArray();
        this.endOfStem = this.buf.length - 1;
        this.endOfTerm = this.buf.length - 1;
    }

    private int m() {
        int n = 0;
        int i = 0;
        while (true) {
            if (i > this.endOfStem) {
                return n;
            }
            if (!PorterStemmer.isConsonant(this.buf, i)) break;
            ++i;
        }
        ++i;
        while (i <= this.endOfStem) {
            if (!PorterStemmer.isConsonant(this.buf, i)) {
                ++i;
                continue;
            }
            ++i;
            ++n;
            while (true) {
                if (i > this.endOfStem) {
                    return n;
                }
                if (!PorterStemmer.isConsonant(this.buf, i)) break;
                ++i;
            }
            ++i;
        }
        return n;
    }

    private boolean cvc(int i) {
        if (i < 2 || !PorterStemmer.isConsonant(this.buf, i) || PorterStemmer.isConsonant(this.buf, i - 1) || !PorterStemmer.isConsonant(this.buf, i - 2)) {
            return false;
        }
        char ch = this.buf[i];
        return ch != 'w' && ch != 'x' && ch != 'y';
    }

    private boolean endsWith(String s) {
        int len = s.length();
        int offset = this.endOfTerm - len + 1;
        if (offset < 0) {
            return false;
        }
        int i = 0;
        while (i < len) {
            if (this.buf[i + offset] != s.charAt(i)) {
                return false;
            }
            ++i;
        }
        this.endOfStem = this.endOfTerm - len;
        return true;
    }

    private void setto(String s) {
        int len = s.length();
        int offset = this.endOfStem + 1;
        int i = 0;
        while (i < len) {
            this.buf[i + offset] = s.charAt(i);
            ++i;
        }
        this.endOfTerm = this.endOfStem + len;
    }

    private void r(String s) {
        if (this.m() > 0) {
            this.setto(s);
        }
    }

    private void step1() {
        if (this.buf[this.endOfTerm] == 's') {
            if (this.endsWith("sses")) {
                this.endOfTerm -= 2;
            } else if (this.endsWith("ies")) {
                this.setto("i");
            } else if (this.buf[this.endOfTerm - 1] != 's') {
                --this.endOfTerm;
            }
        }
        if (this.endsWith("eed")) {
            if (this.m() > 0) {
                --this.endOfTerm;
            }
        } else if ((this.endsWith("ed") || this.endsWith("ing")) && PorterStemmer.hasVowelInStem(this.buf)) {
            this.endOfTerm = this.endOfStem;
            if (this.endsWith("at")) {
                this.setto("ate");
            } else if (this.endsWith("bl")) {
                this.setto("ble");
            } else if (this.endsWith("iz")) {
                this.setto("ize");
            } else if (PorterStemmer.hasDoubleConsonant(this.buf, this.endOfTerm)) {
                --this.endOfTerm;
                char ch = this.buf[this.endOfTerm];
                if (ch == 'l' || ch == 's' || ch == 'z') {
                    ++this.endOfTerm;
                }
            } else if (this.m() == 1 && this.cvc(this.endOfTerm)) {
                this.setto("e");
            }
        }
    }

    private void step2() {
        if (this.endsWith("y") && PorterStemmer.hasVowelInStem(this.buf)) {
            this.buf[this.endOfTerm] = 105;
        }
    }

    private void step3() {
        if (this.endOfTerm <= 0) {
            return;
        }
        switch (this.buf[this.endOfTerm - 1]) {
            case 'a': {
                if (this.endsWith("ational")) {
                    this.r("ate");
                    break;
                }
                if (!this.endsWith("tional")) break;
                this.r("tion");
                break;
            }
            case 'c': {
                if (this.endsWith("enci")) {
                    this.r("ence");
                    break;
                }
                if (!this.endsWith("anci")) break;
                this.r("ance");
                break;
            }
            case 'e': {
                if (!this.endsWith("izer")) break;
                this.r("ize");
                break;
            }
            case 'l': {
                if (this.endsWith("bli")) {
                    this.r("ble");
                    break;
                }
                if (this.endsWith("alli")) {
                    this.r("al");
                    break;
                }
                if (this.endsWith("entli")) {
                    this.r("ent");
                    break;
                }
                if (this.endsWith("eli")) {
                    this.r("e");
                    break;
                }
                if (!this.endsWith("ousli")) break;
                this.r("ous");
                break;
            }
            case 'o': {
                if (this.endsWith("ization")) {
                    this.r("ize");
                    break;
                }
                if (this.endsWith("ation")) {
                    this.r("ate");
                    break;
                }
                if (!this.endsWith("ator")) break;
                this.r("ate");
                break;
            }
            case 's': {
                if (this.endsWith("alism")) {
                    this.r("al");
                    break;
                }
                if (this.endsWith("iveness")) {
                    this.r("ive");
                    break;
                }
                if (this.endsWith("fulness")) {
                    this.r("ful");
                    break;
                }
                if (!this.endsWith("ousness")) break;
                this.r("ous");
                break;
            }
            case 't': {
                if (this.endsWith("aliti")) {
                    this.r("al");
                    break;
                }
                if (this.endsWith("iviti")) {
                    this.r("ive");
                    break;
                }
                if (!this.endsWith("biliti")) break;
                this.r("ble");
                break;
            }
            case 'g': {
                if (!this.endsWith("logi")) break;
                this.r("log");
                break;
            }
        }
    }

    private void step4() {
        switch (this.buf[this.endOfTerm]) {
            case 'e': {
                if (this.endsWith("icate")) {
                    this.r("ic");
                    break;
                }
                if (this.endsWith("ative")) {
                    this.r("");
                    break;
                }
                if (!this.endsWith("alize")) break;
                this.r("al");
                break;
            }
            case 'i': {
                if (!this.endsWith("iciti")) break;
                this.r("ic");
                break;
            }
            case 'l': {
                if (this.endsWith("ical")) {
                    this.r("ic");
                    break;
                }
                if (!this.endsWith("ful")) break;
                this.r("");
                break;
            }
            case 's': {
                if (!this.endsWith("ness")) break;
                this.r("");
                break;
            }
        }
    }

    private void step5() {
        if (this.endOfTerm <= 0) {
            return;
        }
        switch (this.buf[this.endOfTerm - 1]) {
            case 'a': {
                if (this.endsWith("al")) break;
                return;
            }
            case 'c': {
                if (this.endsWith("ance") || this.endsWith("ence")) break;
                return;
            }
            case 'e': {
                if (this.endsWith("er")) break;
                return;
            }
            case 'i': {
                if (this.endsWith("ic")) break;
                return;
            }
            case 'l': {
                if (this.endsWith("able") || this.endsWith("ible")) break;
                return;
            }
            case 'n': {
                if (this.endsWith("ant") || this.endsWith("ement") || this.endsWith("ment") || this.endsWith("ent")) break;
                return;
            }
            case 'o': {
                if (this.endsWith("ion") && this.endOfStem >= 0 && (this.buf[this.endOfStem] == 's' || this.buf[this.endOfStem] == 't') || this.endsWith("ou")) break;
                return;
            }
            case 's': {
                if (this.endsWith("ism")) break;
                return;
            }
            case 't': {
                if (this.endsWith("ate") || this.endsWith("iti")) break;
                return;
            }
            case 'u': {
                if (this.endsWith("ous")) break;
                return;
            }
            case 'v': {
                if (this.endsWith("ive")) break;
                return;
            }
            case 'z': {
                if (this.endsWith("ize")) break;
                return;
            }
            default: {
                return;
            }
        }
        if (this.m() > 1) {
            this.endOfTerm = this.endOfStem;
        }
    }

    private void step6() {
        int a;
        this.endOfStem = this.endOfTerm;
        if (this.buf[this.endOfTerm] == 'e' && ((a = this.m()) > 1 || a == 1 && !this.cvc(this.endOfTerm - 1))) {
            --this.endOfTerm;
        }
        if (this.buf[this.endOfTerm] == 'l' && PorterStemmer.hasDoubleConsonant(this.buf, this.endOfTerm) && this.m() > 1) {
            --this.endOfTerm;
        }
    }
}

