/*
 * Decompiled with CFR 0.152.
 */
package net.trialpc.sticktools.score;

import java.util.ArrayList;
import java.util.Collection;
import net.trialpc.sticktools.Query;
import net.trialpc.sticktools.model.LangModel;
import net.trialpc.sticktools.score.ScoringMethod;

public abstract class AbstractScoringMethod<T extends LangModel>
implements ScoringMethod<T> {
    Collection<Query> queries = new ArrayList<Query>();
    T model = null;
    double score = 0.0;

    @Override
    public void addQueriesAsString(Collection<String> queries) {
        if (queries == null) {
            throw new NullPointerException();
        }
        for (String q : queries) {
            this.addQuery(q);
        }
    }

    @Override
    public void addQueries(Collection<Query> queries) {
        if (queries == null) {
            throw new NullPointerException();
        }
        for (Query q : queries) {
            this.addQuery(q);
        }
    }

    @Override
    public boolean addQuery(String query) {
        if (query == null) {
            throw new NullPointerException();
        }
        if (!query.equals("")) {
            return this.queries.add(new Query(query));
        }
        return false;
    }

    @Override
    public boolean addQuery(Query query) {
        if (query == null) {
            throw new NullPointerException();
        }
        return this.queries.add(query);
    }

    @Override
    public boolean setModel(T model) {
        if (model == null) {
            throw new NullPointerException();
        }
        this.model = model;
        return true;
    }

    @Override
    public void evaluate() {
        if (this.model == null) {
            throw new IllegalStateException();
        }
        this.score = this.evaluateScore(this.model, this.queries);
    }

    @Override
    public double getScore() {
        return this.score;
    }

    protected abstract double evaluateScore(T var1, Collection<Query> var2);
}

