/*
 * Decompiled with CFR 0.152.
 */
package net.trialpc.sticktools.model;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import net.trialpc.sticktools.model.BaseModel;
import net.trialpc.sticktools.model.SentenceModel;
import net.trialpc.sticktools.model.StateChangeListener;
import net.trialpc.sticktools.model.StateChangeObservable;

public class BaseSentence
extends BaseModel
implements SentenceModel,
StateChangeObservable,
Comparable<SentenceModel>,
Serializable {
    private static final long serialVersionUID = 5022983527873139897L;
    private String sentenceId;

    public BaseSentence(String id) {
        if (id == null) {
            id = "";
        }
        this.sentenceId = id;
    }

    @Override
    public String getSentenceId() {
        return this.sentenceId;
    }

    public static BaseSentence unmodifiableSentence(BaseSentence s) {
        if (s == null) {
            throw new NullPointerException();
        }
        return new UnmodifiableSentence(s);
    }

    @Override
    public int hashCode() {
        return this.sentenceId.hashCode() & super.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseSentence)) {
            return false;
        }
        BaseSentence d = (BaseSentence)o;
        if (!this.getSentenceId().equals(d.getSentenceId())) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public int compareTo(SentenceModel o) {
        return this.getSentenceId().compareTo(o.getSentenceId());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.getTerms());
        out.writeObject(this.listeners);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.setTerms(BaseSentence.castMap(in.readObject()));
        this.listeners = BaseSentence.castCollection(in.readObject());
    }

    private static class UnmodifiableSentence
    extends BaseSentence {
        private static final long serialVersionUID = -7295225318731276659L;
        private transient Set<String> vocabulary = null;
        private int numOfVocabulary = -1;

        public UnmodifiableSentence(BaseSentence d) {
            super(d.getSentenceId());
            this.setTerms(Collections.unmodifiableMap(new HashMap<String, Integer>(d.getTerms())));
        }

        @Override
        public void addListener(StateChangeListener listener) {
        }

        @Override
        public boolean addTerm(String t) {
            throw new UnsupportedOperationException("the instance is unmodifiable");
        }

        @Override
        public void addTerms(Collection<String> c) {
            throw new UnsupportedOperationException("the instance is unmodifiable");
        }

        @Override
        public Set<String> getVocabulary() {
            if (this.vocabulary == null) {
                this.vocabulary = Collections.unmodifiableSet(this.getTerms().keySet());
            }
            return this.vocabulary;
        }

        @Override
        public int numOfVocabulary() {
            if (this.numOfVocabulary < 0) {
                this.numOfVocabulary = super.numOfVocabulary();
            }
            return this.numOfVocabulary;
        }

        @Override
        public boolean isModifiable() {
            return false;
        }
    }
}

