/*
 * Decompiled with CFR 0.152.
 */
package net.trialpc.sticktools.model;

import java.util.ArrayList;
import java.util.List;
import net.trialpc.sticktools.StopWord;
import net.trialpc.sticktools.model.LangModel;
import net.trialpc.sticktools.model.LangModels;
import net.trialpc.sticktools.model.ModelBuilder;
import net.trialpc.sticktools.stemmer.Stemmer;

public abstract class AbstractModelBuilder<T extends LangModel>
implements ModelBuilder<T> {
    public static final String DEFAULT_DELIMITER = "[\\s\\p{Punct}]";
    private String delimiter = "[\\s\\p{Punct}]";
    private StopWord stopWord = StopWord.NOTHING;
    private Stemmer stemmer = LangModels.NOTHING_STEMMER;

    public void setStopWord(StopWord stop) {
        if (stop == null) {
            throw new NullPointerException();
        }
        this.stopWord = stop;
    }

    public void setStemmer(Stemmer s) {
        if (s == null) {
            throw new NullPointerException();
        }
        this.stemmer = s;
    }

    public void setDelimiter(String regexp) {
        if (regexp == null) {
            throw new NullPointerException();
        }
        this.delimiter = regexp;
    }

    protected List<String> getTexts(String text) {
        String[] s = text.split(this.delimiter);
        int length = s.length;
        ArrayList<String> list = new ArrayList<String>(length);
        int i = 0;
        while (i < length) {
            if (!s[i].equals("")) {
                String term = s[i];
                if (!this.stopWord.isStopWord(term = this.stemmer.interpret(term))) {
                    list.add(s[i]);
                }
            }
            ++i;
        }
        return list;
    }
}

