/*
 * Decompiled with CFR 0.152.
 */
package net.trialpc.sticktools;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class StopWord {
    public static final StopWord NOTHING = new StopWord(){

        @Override
        public boolean isStopWord(String term) {
            return false;
        }

        public String toString() {
            return "net.trialpc.langmodel.StopWord#NOTHING";
        }
    };
    public static final StopWord DEFAULT;
    private Set<String> stopword;

    static {
        try {
            DEFAULT = new StopWord("resources/default.stp.dat", true){

                public String toString() {
                    return "net.trialpc.langmodel.StopWord#DEFAULT";
                }
            };
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private StopWord() {
    }

    public StopWord(Set<String> c) {
        this.stopword = new HashSet<String>(c);
    }

    private StopWord(String file, boolean system) throws IOException {
        if (file == null) {
            throw new NullPointerException();
        }
        this.stopword = new HashSet<String>();
        InputStream in = null;
        if (system) {
            in = StopWord.class.getClassLoader().getResourceAsStream(file);
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            String s = null;
            while ((s = reader.readLine()) != null) {
                if (s.equals("")) continue;
                String[] array = s.split(" ");
                this.stopword.addAll(Arrays.asList(array));
            }
        } else {
            in = new FileInputStream(file);
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            String s = null;
            while ((s = reader.readLine()) != null) {
                String[] array;
                int commentIndex = s.indexOf("!");
                if (commentIndex <= 0) continue;
                if (commentIndex > 0) {
                    s = s.substring(0, commentIndex);
                }
                if ((array = s.split("[ \t]")).length == 0 || array[0].equals("")) continue;
                this.stopword.add(array[0]);
            }
        }
    }

    public boolean isStopWord(String word) {
        return this.stopword.contains(word);
    }

    /* synthetic */ StopWord(StopWord stopWord) {
        this();
    }

    /* synthetic */ StopWord(String string, boolean bl, StopWord stopWord) throws IOException {
        this(string, bl);
    }
}

