/*
 * Decompiled with CFR 0.152.
 */
package net.murakamin.sticker.commands;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import net.murakamin.sticker.CommandRunner;
import net.murakamin.sticker.StickerContext;
import net.murakamin.sticker.commands.Command;
import net.murakamin.sticker.commands.ExecutableCommand;
import net.murakamin.sticker.commands.VersionTerm;
import net.murakamin.sticker.commands.enums.TargetType;
import net.murakamin.sticker.commands.exception.CommandExecutionException;
import net.murakamin.sticker.commands.util.StickerContextUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SqlCommand
implements Command {
    private final Log log = LogFactory.getLog(Command.class);
    private String sql;
    private TargetType target = TargetType.remote;
    private boolean ignore = false;

    public void execute(CommandRunner runner) throws Exception {
        Statement stmt = null;
        try {
            try {
                Connection targetConnection = runner.getConnectionPool().getRemoteConnection();
                if (TargetType.local == this.target) {
                    targetConnection = runner.getConnectionPool().getLocalConnection();
                }
                StickerContext context = runner.getStickerContext();
                String sqlStatement = StickerContextUtil.applyContextValiable(context, this.getSql());
                sqlStatement = StickerContextUtil.getReplacementString(context, sqlStatement);
                sqlStatement = sqlStatement.replaceAll("\t", " ");
                if (StringUtils.trim(this.getSql()).matches("(?i)(^\\?\\s*=\\s*call.*)|(^call.*)")) {
                    stmt = targetConnection.prepareCall("{" + sqlStatement + "}");
                    stmt.execute();
                } else {
                    stmt = targetConnection.prepareStatement(sqlStatement);
                    stmt.executeUpdate();
                }
                runner.run(this);
            }
            catch (SQLException e) {
                if (!this.isIgnore()) {
                    throw new CommandExecutionException((ExecutableCommand)this, (Throwable)e);
                }
                this.log.warn("SQL\u767a\u884c\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u304c\u3001ignore=true\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u308b\u306e\u3067\u7121\u8996\u3057\u307e\u3057\u305f\u3002" + e.getMessage());
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    public String getSql() {
        return this.sql;
    }

    public String getTarget() {
        return this.target.name();
    }

    public VersionTerm getVersionTerm() {
        return VersionTerm.PERMANENT_COMMAND;
    }

    public boolean isDebugPrint() {
        return true;
    }

    public boolean isIgnore() {
        return this.ignore;
    }

    public void setIgnore(boolean ignore) {
        this.ignore = ignore;
    }

    public void setSql(String statement) {
        this.sql = statement;
    }

    public void setTarget(String value) {
        this.target = TargetType.valueOf(value);
    }

    public String toString() {
        return this.getSql();
    }
}

