/*
 * Decompiled with CFR 0.152.
 */
package net.murakamin.sticker.commands;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import net.murakamin.csv.CSVParser;
import net.murakamin.sticker.CommandRunner;
import net.murakamin.sticker.ConnectionPool;
import net.murakamin.sticker.Sticker;
import net.murakamin.sticker.StickerContext;
import net.murakamin.sticker.commands.Command;
import net.murakamin.sticker.commands.ExecutableCommand;
import net.murakamin.sticker.commands.StickerCSVDataHandler;
import net.murakamin.sticker.commands.VersionTerm;
import net.murakamin.sticker.commands.enums.TargetType;
import net.murakamin.sticker.commands.exception.CommandExecutionException;
import net.murakamin.sticker.commands.util.StickerContextUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.supercsv.io.CsvListWriter;
import org.supercsv.prefs.CsvPreference;

public class ExportCommand
implements Command,
StickerCSVDataHandler {
    private final Log log = LogFactory.getLog(Command.class);
    private ConnectionPool conPool;
    private String destination;
    private String fileCharset = SystemUtils.FILE_ENCODING;
    private boolean header = true;
    private boolean overwrite = true;
    private char quot = '\u0000';
    private char separator = (char)44;
    private String sql = "";
    private TargetType target = TargetType.remote;
    private CsvListWriter writer;
    private StickerContext context;

    /*
     * Unable to fully structure code
     */
    public void addCSVData(String[] currentDatas) throws Exception {
        block15: {
            destination = StickerContextUtil.getReplacementString(this.context, this.getDestination());
            if (!this.conPool.existsLocalTable(destination)) {
                c = 0;
                while (c < currentDatas.length) {
                    if (currentDatas[c] == null) {
                        currentDatas[c] = "";
                    }
                    currentDatas[c] = currentDatas[c].replaceAll("(\r\n)|(\r)", "\n");
                    ++c;
                }
                this.writer.write(currentDatas);
            } else {
                sql = this.createInsertPrepareStatement(destination, currentDatas);
                if ((sql = sql.replaceAll("\t", " ")).charAt(sql.length() - 1) == ';') {
                    sql = sql.substring(0, sql.length() - 1);
                }
                destConnection = this.conPool.getLocalConnection();
                stmt = destConnection.prepareStatement(sql);
                parameterIndex = 1;
                var10_8 = currentDatas;
                var9_11 = currentDatas.length;
                var8_13 = 0;
                while (var8_13 < var9_11) {
                    field = var10_8[var8_13];
                    stmt.setObject(parameterIndex, field);
                    ++parameterIndex;
                    ++var8_13;
                }
                if (Sticker.isDebug()) {
                    buffer = new StringBuffer();
                    var11_18 = currentDatas;
                    var10_9 = currentDatas.length;
                    var9_11 = 0;
                    while (var9_11 < var10_9) {
                        param = var11_18[var9_11];
                        buffer.append('[');
                        buffer.append(param);
                        buffer.append(']');
                        ++var9_11;
                    }
                    this.log.debug(stmt + ": parameters=" + buffer.toString());
                }
                try {
                    try {
                        stmt.execute();
                        break block15;
                    }
                    catch (Exception e) {
                        buffer = new StringBuffer();
                        var12_20 = currentDatas;
                        var11_19 = currentDatas.length;
                        var10_10 = 0;
                        ** while (var10_10 < var11_19)
                    }
lbl-1000:
                    // 1 sources

                    {
                        param = var12_20[var10_10];
                        buffer.append('[');
                        buffer.append(param);
                        buffer.append(']');
                        ++var10_10;
                        continue;
                    }
lbl63:
                    // 1 sources

                    this.log.error(buffer.toString());
                    throw e;
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
        }
    }

    private String createInsertPrepareStatement(String targetTable, String[] values) throws UnsupportedEncodingException {
        StringBuffer sql = new StringBuffer("insert into ");
        sql.append(targetTable);
        sql.append(" values (");
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String field = stringArray[n2];
            sql.append('?');
            sql.append(',');
            ++n2;
        }
        sql.replace(sql.length() - 1, sql.length(), ")");
        return sql.toString();
    }

    public void execute(CommandRunner runner) throws Exception {
        this.conPool = runner.getConnectionPool();
        this.context = runner.getStickerContext();
        if (StringUtils.isEmpty(this.getSql().trim())) {
            throw new CommandExecutionException((ExecutableCommand)this, "SQL of the export is not defined.");
        }
        ResultSet rs = null;
        Statement stmt = null;
        Connection sourceConnection = this.conPool.getRemoteConnection();
        try {
            try {
                if (this.target == TargetType.local) {
                    sourceConnection = this.conPool.getLocalConnection();
                }
                String sql = StickerContextUtil.applyContextValiable(this.context, this.getSql());
                String executableSql = StickerContextUtil.getReplacementString(this.context, sql);
                String destination = StickerContextUtil.getReplacementString(this.context, this.getDestination());
                stmt = sourceConnection.prepareStatement(executableSql);
                rs = stmt.executeQuery();
                if (!this.conPool.existsLocalTable(destination)) {
                    CsvPreference pref = new CsvPreference(this.getQuot(), (int)this.getSeparator(), "\n");
                    File destFile = new File(destination);
                    this.writer = new CsvListWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(destFile, !this.isOverwrite()), this.getFileCharset()), pref);
                    if (this.isHeader()) {
                        ResultSetMetaData rsMetaData = rs.getMetaData();
                        String[] header = new String[rsMetaData.getColumnCount()];
                        int c = 1;
                        while (c < rsMetaData.getColumnCount() + 1) {
                            header[c - 1] = rsMetaData.getColumnName(c);
                            ++c;
                        }
                        if (this.isOverwrite() || !new File(this.destination).exists()) {
                            this.writer.writeHeader(header);
                        }
                    }
                }
                new CSVParser(this).doParse(rs);
                runner.run(this);
            }
            catch (Exception e) {
                throw new CommandExecutionException((ExecutableCommand)this, (Throwable)e);
            }
        }
        finally {
            String destination = StickerContextUtil.getReplacementString(this.context, this.getDestination());
            if (!this.conPool.existsLocalTable(destination) && this.writer != null) {
                this.writer.close();
            }
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    public String getDestination() {
        return this.destination;
    }

    public String getFileCharset() {
        return this.fileCharset;
    }

    public char getQuot() {
        return this.quot;
    }

    public char getSeparator() {
        return this.separator;
    }

    public String getSql() {
        return this.sql;
    }

    public String getTarget() {
        return this.target.name();
    }

    public VersionTerm getVersionTerm() {
        return VersionTerm.PERMANENT_COMMAND;
    }

    public boolean isDebugPrint() {
        return true;
    }

    public boolean isHeader() {
        return this.header;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public void setFileCharset(String fileCharset) {
        this.fileCharset = fileCharset;
    }

    public void setHeader(boolean header) {
        this.header = header;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public void setQuot(char quot) {
        this.quot = quot;
    }

    public void setSeparator(char separator) {
        this.separator = separator;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public void setTarget(String target) {
        this.target = TargetType.valueOf(target);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<export> export execute:\n");
        buffer.append(" destination:");
        buffer.append(this.getDestination());
        buffer.append(SystemUtils.LINE_SEPARATOR);
        buffer.append(" target:");
        buffer.append(this.getTarget());
        buffer.append(SystemUtils.LINE_SEPARATOR);
        buffer.append(" header:");
        buffer.append(this.isHeader());
        buffer.append(SystemUtils.LINE_SEPARATOR);
        buffer.append(" separator:");
        buffer.append(this.getSeparator());
        buffer.append(SystemUtils.LINE_SEPARATOR);
        buffer.append(" quot:");
        buffer.append(this.getQuot() == '\u0000' ? "None" : Character.valueOf(this.getQuot()));
        buffer.append(SystemUtils.LINE_SEPARATOR);
        buffer.append(" charset:");
        buffer.append(this.getFileCharset());
        buffer.append(SystemUtils.LINE_SEPARATOR);
        buffer.append(" sql:");
        buffer.append(this.getSql());
        buffer.append(SystemUtils.LINE_SEPARATOR);
        return buffer.toString();
    }
}

