/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.cellprocessor.constraint;

import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ift.LongCellProcessor;
import org.supercsv.exception.SuperCSVException;
import org.supercsv.util.CSVContext;

public class LMinMax
extends CellProcessorAdaptor {
    public static final long MAXL = Long.MAX_VALUE;
    public static final long MINL = Long.MIN_VALUE;
    public static final int MAX = Integer.MAX_VALUE;
    public static final int MIN = Integer.MIN_VALUE;
    public static final short MAXS = Short.MAX_VALUE;
    public static final short MINS = Short.MIN_VALUE;
    public static final int MAXC = 65535;
    public static final int MINC = 0;
    public static final int MAX8bit = 255;
    public static final int MIN8bit = -128;
    protected long min;
    protected long max;

    public LMinMax(long l, long l2) {
        this.init(l, l2);
    }

    public LMinMax(long l, long l2, LongCellProcessor longCellProcessor) {
        super(longCellProcessor);
        this.init(l, l2);
    }

    public Object execute(Object object, CSVContext cSVContext) throws NumberFormatException {
        Long l = object instanceof Long ? (Long)object : Long.valueOf(Long.parseLong(object.toString()));
        if (l < this.min || l > this.max) {
            throw new SuperCSVException("Entry \"" + object + "\" on line " + cSVContext.lineNumber + " column " + cSVContext.columnNumber + " is not within the numerical range " + this.min + "-" + this.max);
        }
        return this.next.execute(l, cSVContext);
    }

    private void init(long l, long l2) {
        if (l2 < l) {
            throw new SuperCSVException("max < min in the arguments " + l + " " + l2);
        }
        this.min = l;
        this.max = l2;
    }
}

