/*
 * Decompiled with CFR 0.152.
 */
package net.murakamin.sticker;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import net.murakamin.sticker.ConnectionPool;
import net.murakamin.sticker.commands.exception.CommandExecutionException;

final class ConnectionPoolImpl
implements ConnectionPool {
    private String currentConnectionName = null;
    private Connection hsqlDbConnection = null;
    private final List<String> localTableNames = new Vector<String>();
    private final Map<String, Connection> remoteConnections = new Hashtable<String, Connection>();

    ConnectionPoolImpl() {
    }

    public void addLocalTableName(String localTableName) {
        this.localTableNames.add(localTableName);
    }

    public void closeRemoteConnections() throws SQLException {
        for (Connection con : this.remoteConnections.values()) {
            con.close();
        }
    }

    void connectToHsqlDb() throws ClassNotFoundException, SQLException {
        Class.forName("org.hsqldb.jdbcDriver");
        this.hsqlDbConnection = DriverManager.getConnection("jdbc:hsqldb:mem:sticker?shutdown=false", "sa", "");
    }

    protected void disConnectToHsqlDb() {
        if (this.hsqlDbConnection != null) {
            try {
                try {
                    if (!this.hsqlDbConnection.isClosed()) {
                        this.hsqlDbConnection.close();
                    }
                }
                catch (SQLException se) {
                    throw new UnsupportedOperationException();
                }
            }
            finally {
                this.hsqlDbConnection = null;
            }
        }
    }

    public boolean existsLocalTable(String localTableName) {
        return this.localTableNames.contains(localTableName);
    }

    public Connection getLocalConnection() throws CommandExecutionException {
        return this.hsqlDbConnection;
    }

    public Connection getRemoteConnection() throws CommandExecutionException {
        Connection result = this.remoteConnections.get(this.currentConnectionName);
        if (result == null) {
            throw new CommandExecutionException("\u6307\u5b9a\u3055\u308c\u305f\u540d\u524d\u306e\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u63a5\u7d9a\u60c5\u5831\u304c\u5b9a\u7fa9\u3055\u308c\u3066\u3044\u307e\u305b\u3093:" + this.currentConnectionName);
        }
        return result;
    }

    public void setCurrentConnectionName(String name) {
        this.currentConnectionName = name;
    }

    public void setRemoteConnection(String name, Connection con) throws CommandExecutionException {
        if (this.remoteConnections.containsKey(name)) {
            throw new CommandExecutionException("\u6307\u5b9a\u3055\u308c\u305f\u540d\u524d\u306e\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u63a5\u7d9a\u60c5\u5831\u306f\u65e2\u306b\u5b9a\u7fa9\u3055\u308c\u3066\u3044\u307e\u3059" + name);
        }
        this.remoteConnections.put(name, con);
    }
}

