/*
 * Decompiled with CFR 0.152.
 */
package net.murakamin.sticker;

import java.util.ArrayList;
import java.util.List;
import net.murakamin.sticker.ConnectionPool;
import net.murakamin.sticker.ConnectionPoolImpl;
import net.murakamin.sticker.Sticker;
import net.murakamin.sticker.StickerContext;
import net.murakamin.sticker.StickerContextImpl;
import net.murakamin.sticker.commands.ChildCommandExceptionHandler;
import net.murakamin.sticker.commands.Command;
import net.murakamin.sticker.commands.ExceptionCommand;
import net.murakamin.sticker.commands.ParentCommand;
import net.murakamin.sticker.commands.exception.CommandExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandRunner {
    protected static boolean COMMAND_COMPLETE = true;
    protected static boolean CONTINUE_PROCESSING = false;
    private ExceptionCommand exceptionCommand;
    private boolean exceptionCommandSearched = false;
    private final Log log = LogFactory.getLog(CommandRunner.class);

    public static List<Command> findCommand(List<Command> commands, Class<? extends Command> target) {
        ArrayList<Command> result = new ArrayList<Command>();
        for (Command cmd : commands) {
            if (cmd instanceof ParentCommand) {
                result.addAll(CommandRunner.findCommand(((ParentCommand)cmd).getChildlen(), target));
            }
            if (!target.equals(cmd.getClass())) continue;
            result.add(cmd);
        }
        return result;
    }

    protected CommandRunner() {
    }

    public void run(Command target) throws CommandExecutionException {
        ConnectionPoolImpl pool;
        block13: {
            pool = new ConnectionPoolImpl();
            StickerContextImpl context = new StickerContextImpl();
            try {
                try {
                    pool.connectToHsqlDb();
                    this.run(pool, context, target);
                    break block13;
                }
                catch (Exception e) {
                    try {
                        if (this.exceptionCommand != null) {
                            this.exceptionCommand.execute(pool, context);
                            for (Command cmd : this.exceptionCommand.getChildlen()) {
                                this.run(pool, context, cmd);
                            }
                            this.exceptionCommand = null;
                        }
                    }
                    catch (Exception ex) {
                        throw new CommandExecutionException(ex);
                    }
                }
                throw new CommandExecutionException(e);
            }
            finally {
                try {
                    pool.closeRemoteConnections();
                }
                catch (Exception e) {
                    throw new CommandExecutionException(e);
                }
            }
        }
        pool.disConnectToHsqlDb();
    }

    private void run(ConnectionPool pool, StickerContext context, Command target) throws CommandExecutionException {
        if (!this.exceptionCommandSearched && target instanceof ParentCommand) {
            List<Command> result = CommandRunner.findCommand(((ParentCommand)target).getChildlen(), ExceptionCommand.class);
            if (result.size() > 0) {
                this.exceptionCommand = (ExceptionCommand)result.get(0);
            }
            this.exceptionCommandSearched = true;
        }
        if (target instanceof ExceptionCommand) {
            return;
        }
        if (Sticker.isDebug()) {
            this.log.debug(target.toString());
        }
        try {
            target.execute(pool, context);
            if (target instanceof ParentCommand) {
                ((ParentCommand)target).preChildCommandExecute(pool, context);
                for (Command cmd : ((ParentCommand)target).getChildlen()) {
                    this.run(pool, context, cmd);
                }
                ((ParentCommand)target).postChildCommandExecute(pool, context);
            }
        }
        catch (Exception e) {
            if (target instanceof ChildCommandExceptionHandler) {
                try {
                    ((ChildCommandExceptionHandler)((Object)target)).handleException(pool, context);
                }
                catch (Exception ex) {
                    throw new CommandExecutionException(ex);
                }
            }
            this.log.error(target);
            throw new CommandExecutionException(e);
        }
    }
}

