/*
 *  Copyright 2010 argius
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
package net.argius.stew;

import java.util.*;

/**
 * Ce[Ṽ[eBeBB
 */
public final class Iteration {

    private Iteration() {
        // empty
    }

    /**
     * ʑԂB
     * @param <T1> Cӂ̌^1
     * @param <T2> Cӂ̌^2
     * @param it W
     * @param c Ή
     * @return ʑ
     */
    public static <T1, T2> List<T2> map(Iterable<T1> it, Correspondence<T1, T2> c) {
        List<T2> a = new ArrayList<T2>();
        for (T1 o : it) {
            a.add(c.f(o));
        }
        return a;
    }

    /**
     * ʑԂB
     * @param <T1> Cӂ̌^1
     * @param <T2> Cӂ̌^2
     * @param oa z
     * @param c Ή
     * @return ʑ
     */
    public static <T1, T2> List<T2> map(T1[] oa, Correspondence<T1, T2> c) {
        List<T2> a = new ArrayList<T2>();
        for (T1 o : oa) {
            a.add(c.f(o));
        }
        return a;
    }

    /**
     * ʑԂB
     * @param <T1> Cӂ̌^1
     * @param <T2> Cӂ̌^2
     * @param c Ή
     * @param oa z
     * @return ʑ
     */
    public static <T1, T2> List<T2> map(Correspondence<T1, T2> c, T1... oa) {
        List<T2> a = new ArrayList<T2>();
        for (T1 o : oa) {
            a.add(c.f(o));
        }
        return a;
    }

    /**
     * i荞ށB
     * @param <T> Cӂ̌^
     * @param it W
     * @param p q
     * @return i肱܂ꂽ
     */
    public static <T> List<T> narrow(Iterable<T> it, Predicate<T> p) {
        List<T> a = new ArrayList<T>();
        for (T o : it) {
            if (p.f(o)) {
                a.add(o);
            }
        }
        return a;
    }

    /**
     * i荞ށB
     * @param <T> Cӂ̌^
     * @param oa z
     * @param p q
     * @return i肱܂ꂽ
     */
    public static <T> List<T> narrow(T[] oa, Predicate<T> p) {
        List<T> a = new ArrayList<T>();
        for (T o : oa) {
            if (p.f(o)) {
                a.add(o);
            }
        }
        return a;
    }

    /**
     * i荞ށB
     * @param <T> Cӂ̌^
     * @param p q
     * @param oa z
     * @return i肱܂ꂽ
     */
    public static <T> List<T> narrow(Predicate<T> p, T... oa) {
        List<T> a = new ArrayList<T>();
        for (T o : oa) {
            if (p.f(o)) {
                a.add(o);
            }
        }
        return a;
    }

    /**
     * z𐶐B
     * @param it W
     * @param delimiter ؂蕶
     * @return ҏWꂽ
     */
    public static String join(Iterable<?> it, String delimiter) {
        StringBuilder buffer = new StringBuilder();
        for (Object o : it) {
            buffer.append(o);
            buffer.append(delimiter);
        }
        if (buffer.length() == 0) {
            return "";
        }
        return buffer.substring(0, buffer.length() - delimiter.length());
    }

    /**
     * z𐶐B
     * @param <T> Cӂ̌^
     * @param oa z
     * @param delimiter ؂蕶
     * @return ҏWꂽ
     */
    public static <T> String join(T[] oa, String delimiter) {
        StringBuilder buffer = new StringBuilder();
        for (T o : oa) {
            buffer.append(o);
            buffer.append(delimiter);
        }
        if (buffer.length() == 0) {
            return "";
        }
        return buffer.substring(0, buffer.length() - delimiter.length());
    }

    /**
     * z𐶐B
     * @param <T> Cӂ̌^
     * @param delimiter ؂蕶
     * @param oa z
     * @return ҏWꂽ
     */
    public static <T> String join(String delimiter, T... oa) {
        StringBuilder buffer = new StringBuilder();
        for (T o : oa) {
            buffer.append(o);
            buffer.append(delimiter);
        }
        if (buffer.length() == 0) {
            return "";
        }
        return buffer.substring(0, buffer.length() - delimiter.length());
    }

    /**
     * EnumerationIterableƂĕԂB
     * @param <T> vf̌^
     * @param enumeration
     * @return Iterable
     */
    public static <T> Iterable<T> asIterable(final Enumeration<T> enumeration) {
        return new Iterable<T>() {

            public Iterator<T> iterator() {
                return new Iterator<T>() {

                    public boolean hasNext() {
                        return enumeration.hasMoreElements();
                    }

                    public T next() {
                        return enumeration.nextElement();
                    }

                    public void remove() {
                        throw new UnsupportedOperationException("Iterable#remove");
                    }

                };
            }

        };
    }

    /**
     * ΉB
     * @param <T1> Cӂ̌^1
     * @param <T2> Cӂ̌^2
     */
    public interface Correspondence<T1, T2> {

        /**
         * ʑ𓾂B
         * @param preimage 
         * @return ʑ
         */
        T2 f(T1 preimage);

    }

    /**
     * qB
     * @param <T> Cӂ̌^
     */
    public interface Predicate<T> {

        /**
         * 肷B
         * @param element vf
         * @return vf𖞂Ă邩ǂ
         */
        boolean f(T element);

    }

}
