/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.ui.console;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import net.argius.stew.ColumnOrder;
import net.argius.stew.LocalSystem;
import net.argius.stew.ResultSetReference;
import net.argius.stew.text.PrintFormat;
import net.argius.stew.ui.OutputProcessor;
import net.argius.stew.ui.Prompt;
import net.argius.stew.ui.console.Resource;

public final class ConsoleOutputProcessor
implements OutputProcessor {
    private static final int WIDTH_LIMIT = 30;

    public void output(Object object) {
        if (object instanceof ResultSetReference) {
            this.outputResult((ResultSetReference)object);
        } else if (object instanceof ResultSet) {
            this.outputResult(new ResultSetReference((ResultSet)object, ""));
        } else if (object instanceof Prompt) {
            System.err.print(object);
        } else {
            System.out.println(object);
        }
    }

    private void outputResult(ResultSetReference resultSetReference) {
        try {
            ResultSet resultSet = resultSetReference.getResultSet();
            ColumnOrder columnOrder = resultSetReference.getOrder();
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            boolean bl = columnOrder.size() > 0;
            System.err.println();
            int n = bl ? columnOrder.size() : resultSetMetaData.getColumnCount();
            int n2 = 1;
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < n; ++i) {
                int n3;
                int n4 = bl ? columnOrder.getOrder(i) : i + 1;
                int n5 = resultSetMetaData.getColumnDisplaySize(n4);
                if (n5 > 30) {
                    n5 = 30;
                } else if (n5 < 1) {
                    n5 = 1;
                }
                n2 = Math.max(n2, n5);
                switch (resultSetMetaData.getColumnType(n4)) {
                    case -6: 
                    case -5: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        n3 = n5;
                        break;
                    }
                    default: {
                        n3 = -n5;
                    }
                }
                String string = "%" + n3 + "s";
                stringBuilder.append(" " + string);
                if (i != 0) {
                    System.out.print(' ');
                }
                String string2 = bl ? columnOrder.getName(i) : resultSetMetaData.getColumnName(n4);
                System.out.print(PrintFormat.format(string, string2));
            }
            System.out.println();
            String string = stringBuilder.substring(1);
            char[] cArray = new char[n2];
            Arrays.fill(cArray, '-');
            Object[] objectArray = new String[n];
            Arrays.fill(objectArray, String.valueOf(cArray));
            System.out.println(PrintFormat.format(string, objectArray));
            Object[] objectArray2 = new Object[n];
            int n6 = LocalSystem.getPropertyAsInt("net.argius.stew.rowcount.limit", Integer.MAX_VALUE);
            int n7 = 0;
            while (resultSet.next()) {
                if (n7 >= n6) {
                    System.err.println(Resource.getString("w.exceeded-limit", n6));
                    break;
                }
                ++n7;
                for (int i = 0; i < n; ++i) {
                    int n8 = bl ? columnOrder.getOrder(i) : i + 1;
                    objectArray2[i] = resultSet.getString(n8);
                }
                System.out.println(PrintFormat.format(string, objectArray2));
            }
            System.out.println();
            resultSetReference.setRecordCount(n7);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace(System.err);
        }
    }

    public void close() {
    }
}

