/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.argius.stew.CommandException;
import net.argius.stew.Parameter;
import net.argius.stew.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Alias {
    private final Properties properties = new Properties();
    private final File file;
    private long timestamp;

    Alias(File file) {
        this.file = file;
        this.timestamp = 0L;
    }

    String expand(Parameter parameter) {
        return this.expand(parameter.at(0), parameter);
    }

    String expand(String string, Parameter parameter) {
        StringBuilder stringBuilder = new StringBuilder(parameter.asString());
        String string2 = string;
        int n = 100;
        while (this.containsKey(string2)) {
            String string3 = this.getValue(string2);
            stringBuilder.replace(0, string2.length(), string3);
            string2 = new Parameter(stringBuilder.toString()).at(0);
            if (--n >= 0) continue;
            String string4 = Resource.getString("e.alias-circulation-reference", 100);
            throw new CommandException(string4);
        }
        return stringBuilder.toString();
    }

    String getValue(String string) {
        return this.properties.getProperty(string, "");
    }

    void setValue(String string, String string2) {
        this.properties.setProperty(string, string2);
    }

    Object remove(String string) {
        return this.properties.remove(string);
    }

    boolean containsKey(String string) {
        return this.properties.containsKey(string);
    }

    boolean isEmpty() {
        return this.properties.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void load() throws IOException {
        FileInputStream fileInputStream = new FileInputStream(this.file);
        try {
            this.properties.clear();
            this.properties.load(fileInputStream);
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
        this.timestamp = this.file.lastModified();
    }

    void reload() throws IOException {
        if (this.updated()) {
            this.load();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void save() throws IOException {
        if (this.isEmpty()) {
            if (this.file.exists()) {
                this.file.delete();
            }
            return;
        }
        FileOutputStream fileOutputStream = new FileOutputStream(this.file);
        try {
            this.properties.store(fileOutputStream, "");
        }
        finally {
            ((OutputStream)fileOutputStream).close();
        }
        this.timestamp = this.file.lastModified();
    }

    boolean updated() {
        return this.file.lastModified() > this.timestamp;
    }

    Set<Map.Entry<Object, Object>> entrySet() {
        return this.properties.entrySet();
    }
}

