using System;
using System.Collections.Generic;
using System.Drawing.Imaging;
using System.Text;
using Ruby;
using VALUE = System.Int32;
using StarEngine.Core;

namespace StarEngine.Ruby
{
    public partial class RubyInterpreter
    {
        private void InitializeScreenModule()
        {
            IScreen screen = this.GameEnvironment.Screen;

            VALUE mScreen = SERubyConsts.ForName("Screen");

            RUBY.rb_iv_set(mScreen, "@width", RUBY.INT2NUM(screen.Width));
            RUBY.rb_iv_set(mScreen, "@height", RUBY.INT2NUM(screen.Height));

            ITexture csOffscreen = screen.Offscreen;
            VALUE cTexture = SERubyConsts.ForName("Texture");
            VALUE rbOffscreen = RUBY.Send(cTexture, "_orig_new");

            RUBY.rb_iv_set(rbOffscreen, "@width", RUBY.INT2NUM(csOffscreen.Width));
            RUBY.rb_iv_set(rbOffscreen, "@height", RUBY.INT2NUM(csOffscreen.Height));
            this.AddCachedObject(rbOffscreen, csOffscreen);

            RUBY.rb_iv_set(mScreen, "@offscreen", rbOffscreen);

            RUBY.rb_define_singleton_method(mScreen, "save_screenshot", this.mScreen_save_screenshot);
        }

        private VALUE mScreen_save_screenshot(VALUE self, VALUE rbPath)
        {
            string csPath = RUBY.StringValuePtr(rbPath);
            this.GameEnvironment.Screen.SaveScreenshot(csPath, ImageFormat.Png);
            return RUBY.Qnil;
        }
    }
}
