using System;
using System.Collections.Generic;
using System.Text;
using Ruby;
using VALUE = System.Int32;
using ID = System.Int32;

namespace StarEngine.Ruby
{
    public partial class RubyInterpreter
    {
        private void InitializeGameModule()
        {
            VALUE mGame = SERubyConsts.ForName("Game");

            RUBY.rb_define_singleton_method(mGame, "fps", this.mGame_fps);
            RUBY.rb_define_singleton_method(mGame, "fps=", this.mGame_fps_eq);
            RUBY.rb_define_singleton_method(mGame, "real_fps", this.mGame_real_fps);
            RUBY.rb_define_singleton_method(mGame, "__cs_game_run__", this.mGame_cs_game_run);
            RUBY.rb_define_singleton_method(mGame, "running?", this.mGame_running);
            RUBY.rb_define_singleton_method(mGame, "terminate", this.mGame_terminate);
            RUBY.rb_define_singleton_method(mGame, "title", this.mGame_title);
            RUBY.rb_define_singleton_method(mGame, "title=", this.mGame_title_eq);
        }

        private VALUE mGame_fps(VALUE self)
        {
            return RUBY.INT2NUM(Game.Fps);
        }

        private VALUE mGame_fps_eq(VALUE self, VALUE rbFps)
        {
            this.Game.Fps = RUBY.NUM2INT(rbFps);
            return rbFps;
        }

        private VALUE mGame_real_fps(VALUE self)
        {
            return RUBY.rb_float_new(GameEnvironment.RealFps);
        }

        private VALUE mGame_cs_game_run(VALUE self)
        {
            this.GameEnvironment.Run(Game);
            return RUBY.Qnil;
        }

        private VALUE mGame_running(VALUE self)
        {
            return this.GameEnvironment.IsRunning ? RUBY.Qtrue : RUBY.Qfalse;
        }

        private VALUE mGame_terminate(VALUE self)
        {
            this.GameEnvironment.Terminate();
            return RUBY.Qnil;
        }

        private VALUE mGame_title(VALUE self)
        {
            return RUBY.rb_str_new2(Game.Title);
        }

        private VALUE mGame_title_eq(VALUE self, VALUE rbTitle)
        {
            string csTitle = RUBY.StringValuePtr(rbTitle);
            this.Game.Title = csTitle;
            this.GameEnvironment.Title = csTitle;
            return rbTitle;
        }
    }
}