using System;
using System.Collections.Generic;
using System.Drawing;
using System.Text;

namespace StarEngine.Core
{
    /// <summary>
    /// AtBϊ̂߂̍słB
    /// </summary>
    public struct AffineMatrix
    {
        /// <summary>
        /// sB
        /// </summary>
        public static AffineMatrix O
        {
            get { return new AffineMatrix(0, 0, 0, 0, 0, 0); }
        }

        /// <summary>
        /// PʍsB
        /// </summary>
        public static AffineMatrix I
        {
            get { return new AffineMatrix(1, 0, 0, 1, 0, 0); }
        }

        public static bool operator ==(AffineMatrix m1, AffineMatrix m2)
        {
            return m1.A == m2.A && m1.B == m2.B && m1.C == m2.C && m1.D == m2.D &&
                m1.TX == m2.TX && m1.TY == m2.TY;
        }

        public static bool operator !=(AffineMatrix m1, AffineMatrix m2)
        {
            return !(m1 == m2);
        }

        public override bool Equals(object obj)
        {
            return obj is AffineMatrix && this == (AffineMatrix)obj;
        }

        public override int GetHashCode()
        {
            return this.A.GetHashCode() ^ this.B.GetHashCode() ^
                this.C.GetHashCode() ^ this.D.GetHashCode() ^
                this.TX.GetHashCode() ^ this.TY.GetHashCode();
        }

        public override string ToString()
        {
            return string.Format("[[{0},{1},{4}],[{2},{3},{5}],[0,0,1]]",
                this.A, this.B, this.C, this.D, this.TX, this.TY);
        }

        public double A;
        public double B;
        public double C;
        public double D;
        public double TX;
        public double TY;

        public AffineMatrix(double a, double b, double c, double d, double tx, double ty)
        {
            this = new AffineMatrix();
            this.A = a;
            this.B = b;
            this.C = c;
            this.D = d;
            this.TX = tx;
            this.TY = ty;
        }

        /// <summary>
        /// ۂl擾܂B
        /// </summary>
        public bool IsRegular
        {
            get
            {
                return this.A * this.D - this.B * this.C != 0;
            }
        }

        /// <summary>
        /// AtBϊ܂B
        /// </summary>
        /// <param name="m">AtBϊsB</param>
        /// <returns>̍sB</returns>
        public AffineMatrix Concat(AffineMatrix m)
        {
            return this = new AffineMatrix(
                m.A * this.A + m.B * this.C,
                m.A * this.B + m.B * this.D,
                m.C * this.A + m.D * this.C,
                m.C * this.B + m.D * this.D,
                m.TX + m.A * this.TX + m.B * this.TY,
                m.TY + m.C * this.TX + m.D * this.TY);
        }

        /// <summary>
        /// tϊɂ܂B
        /// </summary>
        /// <returns>̍sB</returns>
        public AffineMatrix Invert()
        {
            double det = this.A * this.D - this.B * this.C;
            if (det == 0)
                throw new StarEngineException("not regular exception");
            double newA = this.D / det;
            double newB = -this.B / det;
            double newC = -this.C / det;
            double newD = this.A / det;

            return this = new AffineMatrix(
                newA, newB, newC, newD,
                newA * -this.TX + newB * -this.TY,
                newC * -this.TX + newD * -this.TY);
        }

        /// <summary>
        /// _ɑ΂ĕϊs܂B
        /// </summary>
        /// <param name="point">ϊO̍WB</param>
        /// <returns>ϊ̍WB</returns>
        public PointF Transform(PointF point)
        {
            return new PointF(
                (float)(this.A * point.X + this.B * point.Y + this.TX),
                (float)(this.C * point.X + this.D * point.Y + this.TY)
            );
        }
    }
}
