/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.sqlite.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import static org.junit.Assert.*;

/**
 *
 * @author calico
 */
public class JdbcResultSetTest {

    public JdbcResultSetTest() {
    }

    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    private static final String DRIVER_CLASS = "org.sqlite.Driver";
    private static final String DATABASE = System.getProperty("user.dir") + "/test/unittest.db";
    
    private static Connection newConnection() throws ClassNotFoundException, SQLException {
        Class.forName(DRIVER_CLASS);
        return DriverManager.getConnection("jdbc:sqlite:file:" + DATABASE);
    }
    
    @Test
    public void isLast() throws ClassNotFoundException, SQLException {
        final Connection conn = newConnection();
        try {
            final Statement stmt = conn.createStatement();
            String sql
                    = "CREATE TEMPORARY TABLE IF NOT EXISTS temp_tbl_1("
                        + "  ROWID INTEGER PRIMARY KEY AUTOINCREMENT"
                        + ", ID INTEGER NOT NULL"
                        + ", tVALUE TEXT DEFAULT '_blank'"
                        + ", rVALUE REAL"
                        + ", bVALUE BLOB"
                        + ", nVALUE NULL"
                        + ", tVALUE2 text DEFAULT ''"
                        + ", tVALUE3 VarChar DEFAULT NULL"
                    + ")";
            stmt.executeUpdate(sql);
            sql = "INSERT INTO temp_tbl_1("
                    + "ID"
                    + ", rVALUE"
                    + ", bVALUE"
                    + ", nVALUE"
                + ") VALUES(1, 2.345, X'E38182E38184E38186E38188E3818A00', 10)";
            stmt.executeUpdate(sql);
            stmt.close();

            DatabaseMetaData dbMeta = conn.getMetaData();
            int col = 1;
            for (ResultSet rs = dbMeta.getColumns(null, null, "temp_tbl_1", null); rs.next(); ++col) {
                final boolean isLast = (col == 8);
                assertEquals(isLast, rs.isLast());
            }
        } finally {
            conn.close();
        }
    }
    
    @Test
    public void afterLast() throws ClassNotFoundException, SQLException {
        final Connection conn = newConnection();
        try {
            final Statement stmt = conn.createStatement();
            final String sql = "PRAGMA table_info(sqlite_master)";
            final ResultSet rs = stmt.executeQuery(sql);

            rs.afterLast();
            assertTrue(rs.isAfterLast());
            assertFalse(rs.next());

            rs.close();
            stmt.close();
        } finally {
            conn.close();
        }
    }
    
    @Test
    public void previous() throws ClassNotFoundException, SQLException {
        final Connection conn = newConnection();
        try {
            final Statement stmt = conn.createStatement();
            final String sql = "PRAGMA table_info(sqlite_master)";
            final ResultSet rs = stmt.executeQuery(sql);
            int row = 0;

            assertFalse(rs.previous());
            assertEquals(0, rs.getRow());
            
            assertTrue(rs.next());
            assertEquals(1, rs.getRow());
            assertFalse(rs.previous());
            assertEquals(0, rs.getRow());

            assertTrue(rs.next());
            assertTrue(rs.next());
            assertTrue(rs.next());
            row = rs.getRow();
            assertTrue(rs.previous());
            assertEquals(row - 1, rs.getRow());
            assertTrue(rs.previous());
            assertEquals(row - 2, rs.getRow());
            assertFalse(rs.previous());
            assertEquals(0, rs.getRow());

            rs.close();
            stmt.close();
        } finally {
            conn.close();
        }
    }
    
    @Test
    public void absolute() throws ClassNotFoundException, SQLException {
        final Connection conn = newConnection();
        try {
            final Statement stmt = conn.createStatement();
            String sql
                    = "CREATE TEMPORARY TABLE IF NOT EXISTS temp_tbl_1("
                        + "  ROWID INTEGER PRIMARY KEY AUTOINCREMENT"
                        + ", ID INTEGER NOT NULL"
                        + ", tVALUE TEXT DEFAULT '_blank'"
                        + ", rVALUE REAL"
                        + ", bVALUE BLOB"
                        + ", nVALUE NULL"
                        + ", tVALUE2 text DEFAULT ''"
                        + ", tVALUE3 VarChar DEFAULT NULL"
                    + ")";
            stmt.executeUpdate(sql);
            sql = "INSERT INTO temp_tbl_1("
                    + "ID"
                    + ", rVALUE"
                    + ", bVALUE"
                    + ", nVALUE"
                + ") VALUES(1, 2.345, X'E38182E38184E38186E38188E3818A00', 10)";
            stmt.executeUpdate(sql);
            stmt.executeUpdate(sql);
            stmt.executeUpdate(sql);
            stmt.executeUpdate(sql);
            stmt.executeUpdate(sql);
            stmt.executeUpdate(sql);
            stmt.executeUpdate(sql);
            stmt.executeUpdate(sql);
            stmt.executeUpdate(sql);
            stmt.executeUpdate(sql);
            
            sql = "SELECT * FROM temp_tbl_1";
            final ResultSet rs = stmt.executeQuery(sql);

            assertFalse(rs.absolute(0));
            assertEquals(0, rs.getRow());

            assertTrue(rs.absolute(-1));
            assertTrue(rs.isLast());
            assertEquals(10, rs.getRow());
            
            assertTrue(rs.absolute(-2));
            assertFalse(rs.isBeforeFirst());
            assertFalse(rs.isFirst());
            assertFalse(rs.isLast());
            assertFalse(rs.isAfterLast());
            assertEquals(9, rs.getRow());

            assertTrue(rs.next());
            assertTrue(rs.isLast());
            assertEquals(10, rs.getRow());

            assertTrue(rs.absolute(-10));
            assertFalse(rs.isBeforeFirst());
            assertTrue(rs.isFirst());
            assertEquals(1, rs.getRow());

            assertFalse(rs.absolute(-11));
            assertTrue(rs.isBeforeFirst());
            assertEquals(0, rs.getRow());

            assertFalse(rs.absolute(-12));
            assertTrue(rs.isBeforeFirst());
            assertEquals(0, rs.getRow());
            
            assertFalse(rs.absolute(-13));
            assertTrue(rs.isBeforeFirst());
            assertEquals(0, rs.getRow());
            
            rs.close();
            stmt.close();
        } finally {
            conn.close();
        }
    }
    
    @Test
    public void relative() throws ClassNotFoundException, SQLException {
        final Connection conn = newConnection();
        try {
            final Statement stmt = conn.createStatement();
            String sql
                    = "CREATE TEMPORARY TABLE IF NOT EXISTS temp_tbl_1("
                        + "  ROWID INTEGER PRIMARY KEY AUTOINCREMENT"
                        + ", ID INTEGER NOT NULL"
                        + ", tVALUE TEXT DEFAULT '_blank'"
                        + ", rVALUE REAL"
                        + ", bVALUE BLOB"
                        + ", nVALUE NULL"
                        + ", tVALUE2 text DEFAULT ''"
                        + ", tVALUE3 VarChar DEFAULT NULL"
                    + ")";
            stmt.executeUpdate(sql);
            sql = "INSERT INTO temp_tbl_1("
                    + "ID"
                    + ", rVALUE"
                    + ", bVALUE"
                    + ", nVALUE"
                + ") VALUES(1, 2.345, X'E38182E38184E38186E38188E3818A00', 10)";
            stmt.executeUpdate(sql);
            stmt.executeUpdate(sql);
            stmt.executeUpdate(sql);
            stmt.executeUpdate(sql);
            stmt.executeUpdate(sql);
            stmt.executeUpdate(sql);
            stmt.executeUpdate(sql);
            stmt.executeUpdate(sql);
            stmt.executeUpdate(sql);
            stmt.executeUpdate(sql);
            
            sql = "SELECT * FROM temp_tbl_1";
            final ResultSet rs = stmt.executeQuery(sql);

            assertFalse(rs.relative(0));
            assertEquals(0, rs.getRow());

            assertTrue(rs.next());
            assertEquals(1, rs.getRow());
            assertTrue(rs.relative(0));
            assertEquals(1, rs.getRow());
            
            assertFalse(rs.relative(-1));
            assertEquals(0, rs.getRow());
            
            assertFalse(rs.relative(-2));
            assertTrue(rs.isBeforeFirst());
            assertFalse(rs.isFirst());
            assertFalse(rs.isLast());
            assertFalse(rs.isAfterLast());
            assertEquals(0, rs.getRow());

            assertTrue(rs.relative(3));
            assertEquals(3, rs.getRow());
            
            assertTrue(rs.relative(2));
            assertEquals(5, rs.getRow());
            
            assertTrue(rs.relative(-2));
            assertEquals(3, rs.getRow());

            assertFalse(rs.relative(20));
            assertEquals(10, rs.getRow());
            
            rs.close();
            stmt.close();
        } finally {
            conn.close();
        }
    }

}