using System;
using System.IO;
using System.Runtime.InteropServices;

namespace SQLiteCSLib.Inner
{
	/// <summary>
	/// SQLite3 [Uƍ֐
	/// </summary>
	public class OSQLiteCollation : IDisposable
	{
		/// <summary>
		/// R[obN|C^
		/// </summary>
		protected GCHandle m_callbackpoint ;

		/// <summary>
		/// f[^x[X
		/// </summary>
		protected OSQLiteDBWrap m_db;

		/// <summary>
		/// R[obNC^[tF[X
		/// </summary>
		protected ICollationFunction m_callinterface;

		/// <summary>
		/// R[obN^(}l[W)
		/// </summary>
		unsafe protected delegate int CallCollationDelegate(void* NotUsed,int nKey1, IntPtr pKey1,int nKey2, IntPtr pKey2);

#if MOBILEPC

		/// <summary>
		/// |[OtO
		/// </summary>
		protected IntPtr m_disposeevent = IntPtr.Zero;

		/// <summary>
		/// CLRpR[obNCxg
		/// </summary>
		protected IntPtr m_clrevent;

		/// <summary>
		/// osqlite3collation|C^
		/// </summary>
		protected IntPtr m_nativepoint ;
#endif

		/// <summary>
		/// RXgN^
		/// </summary>
		public OSQLiteCollation( OSQLiteDBWrap db, ICollationFunction iCallinterface )
		{
			m_db = db;
			m_callinterface = iCallinterface;

			unsafe
			{
				m_callbackpoint = GCHandle.Alloc( new CallCollationDelegate( CallCollation ) );
			}

#if MOBILEPC
			m_disposeevent = CreateEvent( IntPtr.Zero , true, false, IntPtr.Zero );
#endif

		}

		/// <summary>
		/// fXgN^
		/// </summary>
		~OSQLiteCollation()
		{
			Dispose();
		}

		/// <summary>
		/// j
		/// </summary>
		public void Dispose()
		{
#if MOBILEPC
			EventModify( m_disposeevent, 3 );
			CloseHandle( m_disposeevent );
			CloseHandle( m_clrevent );
#endif

			if( m_db != null )
			{
				m_callbackpoint.Free();
				m_db = null;
				m_callinterface = null;
			}
		}

		/// <summary>
		/// ֐쐬
		/// </summary>
		/// <param name="funcname"></param>
		/// <returns></returns>
		public ResultEnum CreateFunction( string funcname )
		{
#if MOBILEPC
			m_clrevent = CreateEvent( IntPtr.Zero , false, false, IntPtr.Zero );

			//|[OJn
			System.Threading.Thread thread = new System.Threading.Thread( new System.Threading.ThreadStart(OnCallBackThread) );
			thread.Start();

			return (ResultEnum)osqlite3_createcollation( m_db.internaldb(), funcname, (int)CAPI3REF.UTF16,
				m_clrevent, ref m_nativepoint );
#else
			unsafe
			{
				return (ResultEnum)osqlite3_createcollation( m_db.internaldb(), funcname, (int)CAPI3REF.UTF16,
					m_callbackpoint.Target as CallCollationDelegate );
			}
#endif
		}

#if MOBILEPC

		/// <summary>
		/// R[obNҋ@Xbh
		/// </summary>
		protected void OnCallBackThread()
		{
			//Cxg҂(0..|[O 1..R[obNCxg)
			IntPtr[] handles = new IntPtr[2]{m_disposeevent,m_clrevent};

			while( true )
			{
				int multiWaitRes = WaitForMultipleObjects( 2, handles, false, 3600000 );
				if( multiWaitRes == 0 )
					break;
				if( multiWaitRes == 1 )
				{
					int nKey1 = 0;
					int nKey2 = 0;
					IntPtr pKey1 = IntPtr.Zero;
					IntPtr pKey2 = IntPtr.Zero;

					unsafe
					{
						//R[obN
						void* NotUsed = null;

						//擾
						osqlite3collation_GetCallBackParam( m_nativepoint, ref NotUsed, ref nKey1, ref pKey1, ref nKey2, ref pKey2 );

						//ƍ֐R[
						int iRes = CallCollation( NotUsed, nKey1, pKey1, nKey2, pKey2 );

						//R[obN
						osqlite3collation_FinishCallBackParam( m_nativepoint, iRes );
					}
				}
			}
		}
#endif

		/// <summary>
		/// ƍ֐R[obN
		/// </summary>
		/// <param name="NotUsed">[U|C^</param>
		/// <param name="nKey1">L[1TCY</param>
		/// <param name="pKey1">L[1</param>
		/// <param name="nKey2">L[2TCY</param>
		/// <param name="pKey2">L[2</param>
		/// <returns>r</returns>
		unsafe protected virtual int CallCollation( void* NotUsed,int nKey1, IntPtr pKey1,int nKey2, IntPtr pKey2 )
		{
			//UnicodefR[hsAC^[tF[XR[B
			byte[] bKey1 = new byte[nKey1+2];
			byte[] bKey2 = new byte[nKey2+2];

			Marshal.Copy( pKey1, bKey1, 0, nKey1 );
			Marshal.Copy( pKey2, bKey2, 0, nKey2 );

			System.Text.Decoder dec = System.Text.Encoding.Unicode.GetDecoder();
			int iLen1 = dec.GetCharCount( bKey1,0,nKey1 );
			char[] cKey1 = new char[iLen1];
			dec.GetChars(bKey1,0,nKey1, cKey1, 0 );
			string sKey1 = new string(cKey1);

			int iLen2 = dec.GetCharCount( bKey2,0,nKey2 );
			char[] cKey2 = new char[iLen2];
			dec.GetChars(bKey2,0,nKey2, cKey2, 0 );
			string sKey2 = new string(cKey2);

			return m_callinterface.Compare( sKey1, sKey2 );
		}

		#region A}l[W`

#if MOBILEPC
		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		protected extern static int osqlite3_createcollation( IntPtr instance, string funcname,
			int eTextRep, IntPtr clrevent, ref IntPtr nativepoint );

		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		unsafe protected extern static void osqlite3collation_GetCallBackParam( IntPtr instance, ref void* pNotUsed, ref int pnKey1, ref IntPtr ppKey1,ref int pnKey2, ref IntPtr ppKey2 );

		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		protected extern static void osqlite3collation_FinishCallBackParam( IntPtr instance, int result );

		[DllImport("coredll.dll", SetLastError=true)]
		static extern IntPtr CreateEvent(IntPtr lpsa, bool fManualReset, bool fInitialState, IntPtr lpszEventName );

		[DllImport("coredll.dll", SetLastError=true)]
		static extern bool CloseHandle(IntPtr handle );

		[DllImport("coredll.dll", SetLastError=true)]
		static extern bool EventModify(IntPtr handle, int dEvent );

		[DllImport("coredll.dll", SetLastError=true)]
		static extern int WaitForSingleObject(IntPtr hHandle, int dwMilliseconds);

		[DllImport("coredll.dll", SetLastError=true)]
		static extern int WaitForMultipleObjects( int nCount, IntPtr[] hHandles, bool fWaitAll, int dwMilliseconds);
#else
		[DllImport("osqlite.dll",CharSet = CharSet.Unicode)]
		protected extern static int osqlite3_createcollation( IntPtr instance, string funcname,
			int eTextRep, CallCollationDelegate xCompare );
#endif
		#endregion

	}
}
