
package gunmetry;

import java.awt.Color;
import java.util.ArrayList;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;

/**
 *
 * @author Scientific Open Source projects (Gaku Tanaka)
 * @version 1.0 (Created on 2005/04/18)
 */
public class ImageColorPicker extends javax.swing.JPanel {
	private boolean[] flag;
	private int checkedNumber;
	
	/** Creates new form ImageColorPicker */
	public ImageColorPicker() {
		initComponents();
		
		jTableColors.setDefaultRenderer(Object.class, new ColorTableRenderer());
		
		DefaultTableColumnModel columnModel =(DefaultTableColumnModel)jTableColors.getColumnModel();
		columnModel.getColumn(1).setPreferredWidth(50);		
	}
	
	public void setColorTable(int[] pixels, int[] cluster){
		ArrayList<Integer> colorList = new ArrayList<Integer>();
		for (int i=0; i<pixels.length; i++){
			cluster[i] = colorList.indexOf(pixels[i]);
			if (cluster[i]==-1){
				cluster[i] = colorList.size();
				colorList.add(pixels[i]);
				if (255<colorList.size()){
					colorList.clear();
					return;
				}
			}
		}
		
		DefaultTableModel model = (DefaultTableModel)jTableColors.getModel();
		model.setRowCount(0);
		for (int i=0; i<colorList.size(); i++){
			Object[] rowData = new Object[2];
			rowData[0] = new Color(colorList.get(i));
			rowData[1] = Boolean.FALSE;
			model.addRow(rowData);
		}
	}
	
	public int getColorNumber(){
		return jTableColors.getRowCount();
	}
	
	public boolean[] getFlag(){
		if (flag==null){
			setFlag();
		}
		return flag;
	}
	
	public void clearFlag(){
		flag = null;
	}
	
	public int getCheckedNumber(){
		if (flag==null){
			setFlag();
		}
		return checkedNumber;		
	}
	
	private void setFlag(){
		flag = new boolean[jTableColors.getRowCount()];
		checkedNumber = 0;
		for (int i=0; i<jTableColors.getRowCount(); i++){
			flag[i] = (Boolean)jTableColors.getValueAt(i,1);
			if (flag[i]){
				checkedNumber ++;
			}
		}		
	}
	
	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
    private void initComponents() {//GEN-BEGIN:initComponents
        jScrollPane = new javax.swing.JScrollPane();
        jTableColors = new javax.swing.JTable();

        setLayout(new java.awt.BorderLayout());

        jScrollPane.setPreferredSize(new java.awt.Dimension(200, 100));
        jTableColors.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {

            },
            new String [] {
                "color", "selected"
            }
        ) {
            Class[] types = new Class [] {
                java.lang.Object.class, java.lang.Boolean.class
            };
            boolean[] canEdit = new boolean [] {
                false, true
            };

            public Class getColumnClass(int columnIndex) {
                return types [columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return canEdit [columnIndex];
            }
        });
        jTableColors.setFocusCycleRoot(true);
        jScrollPane.setViewportView(jTableColors);

        add(jScrollPane, java.awt.BorderLayout.CENTER);

    }//GEN-END:initComponents
	
	
    // ϐ錾 - ҏWs//GEN-BEGIN:variables
    private javax.swing.JScrollPane jScrollPane;
    private javax.swing.JTable jTableColors;
    // ϐ錾̏I//GEN-END:variables
	
}
