import gunmetry.ExtractMarkerPlugin;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import javax.swing.SpinnerNumberModel;
import sos.gui.JGenericPanel;

import sos.process.ROI;
/*
 * AnyTopOfDoom.java
 *
 * Created on 2005/03/02, 0:34
 */

/**
 *
 * @author Scientific Open Source projects (Gaku Tanaka)
 * @version 1.0 (2005/03/02)
 */
public class HDoom implements ExtractMarkerPlugin{
	int h;
	JGenericPanel optionPanel = new JGenericPanel();
	
	/** Creates a new instance of AnyTopOfDoom */
	public HDoom() {
		optionPanel.addNumericSpinner("min distance = ", new SpinnerNumberModel(2,1,Integer.MAX_VALUE,1));
		optionPanel.addNumericSpinner("h = ", new SpinnerNumberModel(1,1,Integer.MAX_VALUE,1));
	}
	
	private ROI[] makeROI(int[] label, int width, int height, int nROI, int FIRST_LABEL){
		ROI[] result = new ROI[nROI];
		for (int n=0; n<result.length; n++){
			result[n] = new ROI();
		}
		
		// make the region with adding points
		int offset,pn, index;
		int BACKGROUND = FIRST_LABEL-1;
		for (int y=0; y<height; y++){
			offset = y*width;
			for (int x=0; x<width; x++){
				pn = x + offset;
				if (label[pn]>BACKGROUND){
					index = label[pn]-FIRST_LABEL;
					result[index].expandRegion(x,y);
				}
			}
		}
		
		// set mask within the region
		for (int n=0; n<result.length; n++){
			result[n].initMask();
			Rectangle bounds = result[n].getBounds();
			for (int y=0; y<bounds.height; y++){
				offset = (y+bounds.y)*width;
				for (int x=0; x<bounds.width; x++){
					pn = x+bounds.x+offset;
					if (label[pn]-FIRST_LABEL==n){
						result[n].setMask(x,y);
					}
				}
			}
		}
		
		return result;
	}

	public javax.swing.JPanel getOptionPanel() {
		return optionPanel;
	}

	public ArrayList<Point> extractMarker(sos.process.Morphology mo, boolean[] binaryMap) {
		// get value from optionPanel
		int minDistance = (Integer)optionPanel.getSpinnerNumber(0);
		h = (Integer)optionPanel.getSpinnerNumber(1);
		
		int[] distanceMap = mo.geodesicDistance8(binaryMap);
		int[] distanceMarker = new int[distanceMap.length];
		for (int i=0; i<binaryMap.length; i++){
			if (minDistance<=distanceMap[i]){
				distanceMarker[i] = distanceMap[i]-h;
			}else{
				distanceMarker[i] = distanceMap[i];
			}
		}
		mo.reconstruct8(distanceMap,distanceMarker);
		boolean[] topMap = new boolean[distanceMap.length];
		for (int i=0; i<binaryMap.length; i++){
			topMap[i] = (0<distanceMap[i]-distanceMarker[i]);
		}
		
		int nRegion = mo.extractRegion8(topMap, distanceMarker);
		ROI[] rois = makeROI(distanceMarker,mo.getWidth(),mo.getHeight(),nRegion,0);
		ArrayList<Point> result = new ArrayList<Point>();
		for (int i=0; i<rois.length; i++){
			Point2D.Double p2D = rois[i].getCentroid();
			Point p = new Point((int)Math.round(p2D.x),(int)Math.round(p2D.y));
			result.add(p);
		}
		
		return result;		
	}
}
