
/*
 * NuclearFormFactor.java
 *
 * Created on 2005/03/07, 1:45
 */

import gunmetry.AnalyzePlugin;
import java.util.ArrayList;
import sos.process.NeighborFrame;
import sos.process.ROI;

/**
 *
 * @author pathologist
 */
public class RegionFormFactor implements AnalyzePlugin{
	
	private ArrayList<Double> result = null;
	
	protected double calcFormFactor(ROI roi){
		// make new texture
		int width = roi.getWidth();
		int height = roi.getHeight();
		boolean[] textureCircle = new boolean[(width+2)*(height+2)];
		int offset;
		for (int y=0; y<height; y++){
			offset = y*width;
			for (int x=0; x<width; x++){
				if (roi.getMask(x+offset)){
					textureCircle[x+1+offset+width] = true;
				}
			}
		}
		// dilation
		NeighborFrame nf = new NeighborFrame(width+2,height+2);
		nf.set4();
		int[] neighbor;
		for (int pn=0; pn<textureCircle.length; pn++){
			if (!textureCircle[pn]){
				neighbor = nf.getExist(pn);
				for (int n=0; n<neighbor.length; n++){
					if (textureCircle[pn+neighbor[n]]){
						textureCircle[pn]=true;
						break;
					}
				}
			}
		}
		
		// find the top-left point
		int index = width+2;
		while(!textureCircle[index]){
			index++;
		}
		
		// calculate the cycle of nuclei
		int cp = index;
		int cn, direction = -1;
		int perimeter = 0;
		nf.set8();
		do{
			neighbor = nf.getDir(cp);
			for (int i=0; i<8; i++){
				direction = (direction+1)%8;
				cn = cp+neighbor[direction];
				if (cn!=cp && textureCircle[cn]){
					cp = cn;
					direction += 4;
					perimeter++;
					break;
				}
			}
		}while(cp!=index);
		
		return 4.0*Math.PI*roi.getSize()/(perimeter*perimeter);
	}

	public ArrayList<Double> analyze(ROI[] nuclei, ROI[] skiz) {
		if (result==null){
			result = new ArrayList<Double>();
			for (int i=0; i<nuclei.length; i++){
				result.add(calcFormFactor(nuclei[i]));
			}
		}
		return result;
	}
}
