/*
 * Decompiled with CFR 0.152.
 */
package sos.util;

public abstract class Sort {
    protected int[] ascendingOrder = null;
    protected int minIndex = -1;
    protected int maxIndex = -1;
    protected int inputLength;
    protected int range;
    protected int offset;
    protected int[] heap;

    public final int[] getOrder() {
        return this.ascendingOrder;
    }

    public final void setOrder(int[] order) {
        this.ascendingOrder = order;
    }

    public final int getOrder(int index) {
        return this.ascendingOrder[index];
    }

    public final int[] getRank() {
        int[] ranking = new int[this.ascendingOrder.length];
        for (int i = 0; i < this.ascendingOrder.length; ++i) {
            ranking[this.ascendingOrder[i]] = i;
        }
        return ranking;
    }

    public abstract int[] getTieRank();

    public abstract void findMin();

    public abstract void findMax();

    protected void swap(int i, int j) {
        int value = this.heap[i];
        this.heap[i] = this.heap[j];
        this.heap[j] = value;
    }

    public abstract int[] getDistributive();

    public abstract void sortAdditional(int var1, int var2);

    protected abstract void sort();

    public final Object[] sort(Object[] data) {
        Object[] result = (Object[])data.clone();
        for (int i = 0; i < data.length; ++i) {
            int index = this.ascendingOrder[i];
            result[i] = data[this.ascendingOrder[i]];
        }
        return result;
    }

    public final double[] sort(double[] data) {
        double[] result = new double[data.length];
        for (int i = 0; i < data.length; ++i) {
            result[i] = data[this.ascendingOrder[i]];
        }
        return result;
    }

    public final int[] sort(int[] data) {
        int[] result = new int[data.length];
        for (int i = 0; i < data.length; ++i) {
            result[i] = data[this.ascendingOrder[i]];
        }
        return result;
    }

    protected void setRange(int start, int end) {
        this.offset = start;
        this.range = end - start;
    }

    protected void initAscendingOrder(int l) {
        this.ascendingOrder = new int[l];
        for (int i = 0; i < l; ++i) {
            this.ascendingOrder[i] = i;
        }
    }
}

