/*
 * Decompiled with CFR 0.152.
 */
package sos.threedim;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Line2D;
import sos.math.MathMx;
import sos.threedim.Line3D;
import sos.threedim.Object3D;
import sos.threedim.Vertex;

public class TransformedView {
    private static final BasicStroke SOLID_LINE;
    private static final BasicStroke DASHED_LINE;
    private static final Line3D[] AXIS;
    public static final int INDEX_NO_VERTEX = -2;
    public static final int INDEX_CENTER = -1;
    private static int[] location;
    private double[] dummyVertex = new double[]{0.0, 0.0, 0.0, 1.0};
    private int[] dummyLocation = new int[]{0, 0, 0, 1};
    private double[] dVertex = new double[3];
    private double[][] transformMx = new double[4][4];
    private double[][] invTransformMx = new double[4][4];
    private double[][] viewMx = new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}};
    private boolean useLocalMatrix;
    private boolean useLocalOffset;
    private boolean originAtCentroid = false;
    private double[][] rotMx = new double[4][4];
    private Object3D object;
    private int vertexRadius = 3;
    private int vertexDiameter = 5;
    private Image backgroundImage = null;

    public TransformedView(int width, int height) {
        this.setViewOffset((double)width / 2.0, (double)height / 2.0);
    }

    public TransformedView(double[][] mx, int width, int height) {
        this(width, height);
        this.setView(mx);
    }

    public void setView(double[][] mx) {
        for (int i = 0; i < 3; ++i) {
            System.arraycopy(mx[i], 0, this.viewMx[i], 0, 3);
        }
    }

    private void setVertexLocation(Object3D object, int index) {
        double[] source = index == -1 ? object.getCenterLocation() : object.getVertexLocation(index);
        System.arraycopy(source, 0, this.dummyVertex, 0, source.length);
        this.dummyVertex[3] = 1.0;
        MathMx.multiple(this.dummyVertex, this.transformMx, this.dummyLocation);
        System.arraycopy(this.dummyLocation, 0, location, 0, 2);
    }

    private void reverseTransform(int dx, int dy) {
        this.dummyLocation[0] = dx;
        this.dummyLocation[1] = dy;
        this.dummyLocation[2] = 0;
        this.dummyLocation[3] = 0;
        MathMx.inverse(this.transformMx, this.invTransformMx);
        MathMx.multiple(this.dummyLocation, this.invTransformMx, this.dummyVertex);
        System.arraycopy(this.dummyVertex, 0, this.dVertex, 0, this.dVertex.length);
    }

    private boolean contains(double radius, int x, int y) {
        double distance = Math.sqrt((location[0] - x) * (location[0] - x) + (location[1] - y) * (location[1] - y));
        return distance <= radius;
    }

    public boolean isWithinObject(int x, int y) {
        this.setVertexLocation(this.object, -1);
        double r = this.object.getBoundsRadius() + (double)this.vertexDiameter;
        return this.contains(r, x, y);
    }

    public boolean isWithinCenter(int x, int y) {
        this.setVertexLocation(this.object, -1);
        return this.contains(this.vertexRadius, x, y);
    }

    public void drawVertices(Graphics g) {
        for (int i = 0; i < this.object.getVertexNumber(); ++i) {
            this.drawVertex(g, i);
        }
    }

    public void drawVertex(Graphics g, int vertexIndex) {
        g.setColor(this.object.getVertex(vertexIndex).getColor());
        this.setVertexLocation(this.object, vertexIndex);
        this.drawLocationRect(g);
    }

    public void fillVertices(Graphics g) {
        for (int i = 0; i < this.object.getVertexNumber(); ++i) {
            this.fillVertex(g, i);
        }
    }

    public void fillVertex(Graphics g, int vertexIndex) {
        this.setVertexLocation(this.object, vertexIndex);
        this.fillLocationRect(g);
    }

    public void drawCenter(Graphics g) {
        g.setColor(this.object.getCenter().getColor());
        this.setVertexLocation(this.object, -1);
        this.fillLocationRect(g);
    }

    public void drawOpenCurve(Graphics g) {
        for (int i = 0; i < this.object.getVertexNumber() - 1; ++i) {
            this.drawSegment(g, i, i + 1);
        }
    }

    public void drawCloseCurve(Graphics g) {
        this.drawOpenCurve(g);
        this.drawSegment(g, 0, this.object.getVertexNumber() - 1);
    }

    private void drawSegment(Graphics g, int vertexIndex1, int vertexIndex2) {
        int[] p = this.calcSegment(this.object, vertexIndex1, vertexIndex2);
        g.drawLine(p[0], p[1], p[2], p[3]);
    }

    private int[] calcSegment(Object3D object, int vertexIndex1, int vertexIndex2) {
        int[] result = new int[4];
        this.setVertexLocation(object, vertexIndex1);
        System.arraycopy(location, 0, result, 0, location.length);
        this.setVertexLocation(object, vertexIndex2);
        System.arraycopy(location, 0, result, 2, location.length);
        return result;
    }

    private void drawAxisComponent(Graphics2D g2, BasicStroke stroke, Object3D object) {
        g2.setStroke(stroke);
        int[] p = this.calcSegment(object, 0, 1);
        g2.draw(new Line2D.Double(p[0], p[1], p[2], p[3]));
    }

    public void drawAxis(Graphics g) {
        for (int i = 0; i < this.transformMx.length; ++i) {
            System.arraycopy(this.viewMx[i], 0, this.transformMx[i], 0, 2);
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(Color.red);
        this.drawAxisComponent(g2, SOLID_LINE, AXIS[0]);
        this.drawAxisComponent(g2, DASHED_LINE, AXIS[3]);
        g2.setColor(Color.green);
        this.drawAxisComponent(g2, SOLID_LINE, AXIS[1]);
        this.drawAxisComponent(g2, DASHED_LINE, AXIS[4]);
        g2.setColor(Color.blue);
        this.drawAxisComponent(g2, SOLID_LINE, AXIS[2]);
        this.drawAxisComponent(g2, DASHED_LINE, AXIS[5]);
        g2.setStroke(new BasicStroke());
    }

    private void drawLocationRect(Graphics g) {
        g.drawRect(location[0] - this.vertexRadius, location[1] - this.vertexRadius, this.vertexDiameter, this.vertexDiameter);
    }

    private void fillLocationRect(Graphics g) {
        g.fillRect(location[0] - this.vertexRadius, location[1] - this.vertexRadius, this.vertexDiameter, this.vertexDiameter);
    }

    public void setOriginAtCentroid(boolean value) {
        this.originAtCentroid = value;
    }

    public void setObject(Object3D object) {
        this.object = object;
        this.updateTransformMx();
    }

    public void updateTransformMx() {
        if (this.object != null) {
            this.object.setLocalMatrix(this.useLocalMatrix, this.useLocalOffset, this.originAtCentroid);
            double[][] localMx = this.object.getLocalMatrix();
            MathMx.multiple(localMx, this.viewMx, this.transformMx);
        }
    }

    public void setBackgroundImage(Image img) {
        this.backgroundImage = img;
    }

    public int getActiveVertex(int x, int y) {
        if (this.object == null) {
            return -2;
        }
        this.setVertexLocation(this.object, -1);
        if (this.contains(this.vertexRadius, x, y)) {
            return -1;
        }
        for (int i = 0; i < this.object.getVertexNumber(); ++i) {
            this.setVertexLocation(this.object, i);
            if (!this.contains(this.vertexRadius, x, y)) continue;
            return i;
        }
        return -2;
    }

    public void setWorldCondition(boolean matrix, boolean offset, boolean centroid) {
        this.useLocalMatrix = matrix;
        this.useLocalOffset = offset;
        this.originAtCentroid = centroid;
    }

    public void moveVertex(int vertexIndex, int dx, int dy) {
        this.reverseTransform(dx, dy);
        Vertex v = this.object.getVertex(vertexIndex);
        v.translate(this.dVertex);
        this.object.update();
    }

    public void moveObject(int dx, int dy) {
        this.reverseTransform(dx, dy);
        this.object.translate(this.dVertex);
        this.object.update();
    }

    public void translateLocalOffset(int dx, int dy) {
        this.reverseTransform(dx, dy);
        this.object.translateLocalOffset(this.dVertex);
        this.object.update();
    }

    public void rotateXAxis(double theta) {
        this.rotate(this.viewMx[0][0], this.viewMx[1][0], this.viewMx[2][0], theta);
    }

    public void rotateYAxis(double theta) {
        this.rotate(this.viewMx[0][1], this.viewMx[1][1], this.viewMx[2][1], theta);
    }

    private void rotate(double x, double y, double z, double theta) {
        double cos = Math.cos(theta);
        double cosInv = 1.0 - cos;
        double sin = Math.sin(theta);
        double offX = this.viewMx[3][0];
        double offY = this.viewMx[3][1];
        this.rotMx[0][0] = x * x * cosInv + cos;
        this.rotMx[1][0] = x * y * cosInv + z * sin;
        this.rotMx[2][0] = z * x * cosInv - y * sin;
        this.rotMx[0][1] = x * y * cosInv - z * sin;
        this.rotMx[1][1] = y * y * cosInv + cos;
        this.rotMx[2][1] = y * z * cosInv + x * sin;
        this.rotMx[0][2] = z * x * cosInv + y * sin;
        this.rotMx[1][2] = y * z * cosInv - x * sin;
        this.rotMx[2][2] = z * z * cosInv + cos;
        double[][] newView = MathMx.multiple(this.rotMx, this.viewMx);
        newView[3][0] = offX;
        newView[3][1] = offY;
        this.viewMx = newView;
        this.updateTransformMx();
    }

    public void drawBackgroundImage(Graphics g) {
        if (this.backgroundImage != null) {
            g.drawImage(this.backgroundImage, 0, 0, null);
        }
    }

    public void scaleViewMx(double ratio, double x, double y) {
        for (int i = 0; i < 3; ++i) {
            int j = 0;
            while (j < 3) {
                double[] dArray = this.viewMx[i];
                int n = j++;
                dArray[n] = dArray[n] * ratio;
            }
        }
        this.setViewOffset((1.0 - ratio) * x + ratio * this.viewMx[3][0], (1.0 - ratio) * y + ratio * this.viewMx[3][1]);
    }

    public void translateViewMx(double dx, double dy) {
        double[] dArray = this.viewMx[3];
        dArray[0] = dArray[0] + dx;
        double[] dArray2 = this.viewMx[3];
        dArray2[1] = dArray2[1] + dy;
        this.updateTransformMx();
    }

    public void setViewOffset(double x, double y) {
        this.viewMx[3][0] = x;
        this.viewMx[3][1] = y;
        this.updateTransformMx();
    }

    public void setViewScale(double ratio) {
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                if (this.viewMx[y][x] == 0.0) continue;
                double[] dArray = this.viewMx[y];
                int n = x;
                dArray[n] = dArray[n] * (ratio / Math.abs(this.viewMx[y][x]));
            }
        }
    }

    public void drawObject(Graphics g, boolean drawVertex, boolean drawCenter) {
        if (this.object == null) {
            return;
        }
        g.setColor(this.object.getLineColor());
        this.drawCloseCurve(g);
        if (drawVertex) {
            for (int i = 0; i < this.object.getVertexNumber(); ++i) {
                this.drawVertex(g, i);
            }
        }
        if (drawCenter) {
            this.drawCenter(g);
        }
    }

    public Object3D getObject() {
        return this.object;
    }

    static {
        location = new int[2];
        SOLID_LINE = new BasicStroke();
        DASHED_LINE = new BasicStroke(0.0f, 0, 0, 10.0f, new float[]{2.0f}, 2.0f);
        int length = 100;
        AXIS = new Line3D[6];
        TransformedView.AXIS[0] = new Line3D(new Vertex(0.0, 0.0, 0.0), new Vertex(length, 0.0, 0.0));
        TransformedView.AXIS[1] = new Line3D(new Vertex(0.0, 0.0, 0.0), new Vertex(0.0, length, 0.0));
        TransformedView.AXIS[2] = new Line3D(new Vertex(0.0, 0.0, 0.0), new Vertex(0.0, 0.0, length));
        TransformedView.AXIS[3] = new Line3D(new Vertex(0.0, 0.0, 0.0), new Vertex(-length, 0.0, 0.0));
        TransformedView.AXIS[4] = new Line3D(new Vertex(0.0, 0.0, 0.0), new Vertex(0.0, -length, 0.0));
        TransformedView.AXIS[5] = new Line3D(new Vertex(0.0, 0.0, 0.0), new Vertex(0.0, 0.0, -length));
    }
}

