/*
 * Decompiled with CFR 0.152.
 */
package sos.threedim;

import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import sos.math.MathMx;
import sos.math.MathVector;
import sos.threedim.Vertex;
import sos.util.MinMaxDouble;

public class Object3D
implements Serializable {
    private static final long serialVersionUID = -1483945178505123097L;
    private static final double[][] UNIT_LOCAL_MATRIX = new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}};
    private static final double[] NO_OFFSET = new double[]{0.0, 0.0, 0.0};
    private static double[] dummyPreVertex = new double[4];
    private static double[] dummyPostVertex = new double[4];
    protected ArrayList<Vertex> vertices = new ArrayList();
    protected Vertex center = new Vertex();
    protected double boundsRadius;
    private Color lineColor = Color.black;
    private double[][] localDummyMatrix = new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}};
    protected double[][] localMatrix = new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}};
    protected double[] localOffset = new double[]{0.0, 0.0, 0.0};
    private int userIndex = -1;

    public void setLocalMatrix(boolean useWorldMx, boolean useWorldOffset, boolean originAtCenter) {
        double[][] mx = useWorldMx ? this.localMatrix : UNIT_LOCAL_MATRIX;
        for (int y = 0; y < 3; ++y) {
            System.arraycopy(mx[y], 0, this.localDummyMatrix[y], 0, 3);
        }
        double[] offset = useWorldOffset ? (double[])this.localOffset.clone() : (double[])NO_OFFSET.clone();
        if (originAtCenter) {
            double[] center = this.getCenterLocation();
            for (int i = 0; i < 3; ++i) {
                int n = i;
                offset[n] = offset[n] - center[i];
            }
        }
        for (int i = 0; i < 3; ++i) {
            this.localDummyMatrix[3][i] = offset[i];
        }
    }

    public double[][] getLocalMatrix() {
        return this.localDummyMatrix;
    }

    public Vertex getCenter() {
        return this.center;
    }

    public int getVertexNumber() {
        return this.vertices.size();
    }

    protected void update() {
        this.calculateCenter();
        this.calculateBoundsRadius();
    }

    private void calculateBoundsRadius() {
        MinMaxDouble mmd = new MinMaxDouble();
        mmd.setInit(this.center.distanceSq(this.vertices.get(0)));
        for (int i = 1; i < this.vertices.size(); ++i) {
            mmd.compareMax(this.center.distanceSq(this.vertices.get(i)));
        }
        this.boundsRadius = Math.sqrt(mmd.getValue());
    }

    public double[] getCenterLocation() {
        return this.center.getLocation();
    }

    public double[] getTransformedCenterLocation() {
        return this.transform(this.center);
    }

    public double getBoundsRadius() {
        return this.boundsRadius;
    }

    public final void removeVertex(int index) {
        if (index < 0) {
            return;
        }
        this.vertices.remove(index);
        this.update();
    }

    public int getNearestVertexIndex(double[] coordinate) {
        return this.getNearestVertexIndex(coordinate, 0, this.vertices.size());
    }

    public int getNearestVertexIndex(double[] coordinate, int start, int end) {
        MinMaxDouble mmd = new MinMaxDouble();
        double d = MathVector.norm(this.transform(this.vertices.get(start)), coordinate);
        mmd.setInit(d);
        for (int i = start + 1; i < end; ++i) {
            d = MathVector.norm(this.transform(this.vertices.get(i)), coordinate);
            mmd.compareMin(d);
        }
        return mmd.getIndex();
    }

    public void translate(double dx, double dy, double dz) {
        for (int i = 0; i < this.vertices.size(); ++i) {
            Vertex v = this.vertices.get(i);
            v.translate(dx, dy, dz);
        }
        this.update();
    }

    public void translate(double[] d) {
        for (int i = 0; i < this.vertices.size(); ++i) {
            Vertex v = this.vertices.get(i);
            v.translate(d);
        }
        this.update();
    }

    public void calculateCenter() {
        this.center.reset();
        for (int i = 0; i < this.vertices.size(); ++i) {
            Vertex v = this.vertices.get(i);
            this.center.translate(v.getLocation());
        }
        double[] centerArray = this.center.getLocation();
        centerArray[0] = centerArray[0] / (double)this.vertices.size();
        centerArray[1] = centerArray[1] / (double)this.vertices.size();
        centerArray[2] = centerArray[2] / (double)this.vertices.size();
    }

    public void subdivide() {
        ArrayList<Vertex> newPoints = new ArrayList<Vertex>();
        for (int i = 0; i < this.vertices.size() - 1; ++i) {
            newPoints.add(this.vertices.get(i));
            Vertex newP = this.calcMeanPoint(i, i + 1);
            newPoints.add(newP);
        }
        newPoints.add(this.vertices.get(this.vertices.size() - 1));
        Vertex newP = this.calcMeanPoint(0, this.vertices.size() - 1);
        newPoints.add(newP);
        this.vertices = newPoints;
    }

    private Vertex calcMeanPoint(int index1, int index2) {
        Vertex p1 = this.vertices.get(index1);
        Vertex p2 = this.vertices.get(index2);
        double x = (p1.getX() + p2.getX()) / 2.0;
        double y = (p1.getY() + p2.getY()) / 2.0;
        double z = (p1.getZ() + p2.getZ()) / 2.0;
        return new Vertex(x, y, z);
    }

    public void setLocalCondition(double[][] mx, double[] offset) {
        this.localMatrix = mx;
        this.localOffset = offset;
    }

    public Vertex getVertex(int index) {
        return this.vertices.get(index);
    }

    public double[] getVertexLocation(int index) {
        return this.vertices.get(index).getLocation();
    }

    public double[] getTransformedVertexLocation(int index) {
        return this.transform(this.vertices.get(index));
    }

    public void addVertex(Vertex v) {
        this.vertices.add(v);
    }

    public void addVertex(double[] coordinates) {
        Vertex newVertex = new Vertex(coordinates);
        this.vertices.add(newVertex);
    }

    public double getMinX() {
        MinMaxDouble mmd = new MinMaxDouble();
        mmd.setInit(this.vertices.get(0).getX());
        for (int i = 1; i < this.vertices.size(); ++i) {
            mmd.compareMin(this.vertices.get(i).getX());
        }
        return mmd.getValue();
    }

    public double getMinY() {
        MinMaxDouble mmd = new MinMaxDouble();
        mmd.setInit(this.vertices.get(0).getY());
        for (int i = 1; i < this.vertices.size(); ++i) {
            mmd.compareMin(this.vertices.get(i).getY());
        }
        return mmd.getValue();
    }

    public double getMinZ() {
        MinMaxDouble mmd = new MinMaxDouble();
        mmd.setInit(this.vertices.get(0).getZ());
        for (int i = 1; i < this.vertices.size(); ++i) {
            mmd.compareMin(this.vertices.get(i).getZ());
        }
        return mmd.getValue();
    }

    public void setUserIndex(int value) {
        this.userIndex = value;
    }

    public int getUserIndex() {
        return this.userIndex;
    }

    public void scaleLocalMatrix(double ratio) {
        int i = 0;
        while (i < 3) {
            double[] dArray = this.localMatrix[i];
            int n = i++;
            dArray[n] = dArray[n] * ratio;
        }
    }

    public void translateLocalOffset(double[] d) {
        for (int i = 0; i < 3; ++i) {
            int n = i;
            this.localOffset[n] = this.localOffset[n] + d[i];
        }
    }

    private double[] transform(Vertex vertex) {
        double[] v = vertex.getLocation();
        Object3D.dummyPreVertex[3] = 1.0;
        System.arraycopy(v, 0, dummyPreVertex, 0, 3);
        MathMx.multiple(dummyPreVertex, this.localDummyMatrix, dummyPostVertex);
        double[] transVertex = new double[3];
        System.arraycopy(dummyPostVertex, 0, transVertex, 0, 3);
        return transVertex;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color lineColor) {
        this.lineColor = lineColor;
    }
}

