/*
 * Decompiled with CFR 0.152.
 */
package sos.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JFileChooser;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import sos.io.Extension;
import sos.io.ExtensionFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOSFileIO {
    public static final ExtensionFilter txtFilter = new ExtensionFilter(new String[]{"txt"}, "Text File");
    public static final String separator = System.getProperty("file.separator");
    private static String defaultFileName;
    private static LookAndFeel defaultLF;
    protected JFileChooser chooser = new JFileChooser();

    private void setSystemLookAndFeel() {
        defaultLF = UIManager.getLookAndFeel();
        String systemLF = UIManager.getSystemLookAndFeelClassName();
        try {
            UIManager.setLookAndFeel(systemLF);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setDefaultLookAndFeel() {
        try {
            UIManager.setLookAndFeel(defaultLF);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void resetChoosableFileFilters() {
        this.chooser.resetChoosableFileFilters();
    }

    public void setFileFilter(FileFilter filter) {
        this.chooser.setFileFilter(filter);
    }

    public void addChoosableFileFilter(FileFilter filter) {
        this.chooser.addChoosableFileFilter(filter);
    }

    public File getOpenFile() {
        return this.getFile("Open file...", true);
    }

    public File getSaveFile() {
        return this.getFile("Save file...", false);
    }

    public File getOpenFile(String title) {
        return this.getFile(title, true);
    }

    public File getSaveFile(String title) {
        return this.getFile(title, false);
    }

    public File getOpenDirectory() {
        this.chooser.setFileSelectionMode(1);
        File file = this.getOpenFile("Select folder to open...");
        this.chooser.setFileSelectionMode(0);
        return file;
    }

    public File getSaveDirectory() {
        this.chooser.setFileSelectionMode(1);
        File file = this.getSaveFile("Select folder to save...");
        this.chooser.setFileSelectionMode(0);
        return file;
    }

    public void setCurrentDirectory(File dir) {
        this.chooser.setCurrentDirectory(dir);
    }

    public void setCurrentDirectory(String path) {
        this.chooser.setCurrentDirectory(new File(path));
    }

    private File getFile(String title, boolean isOpen) {
        FileFilter filter = this.chooser.getFileFilter();
        this.setSystemLookAndFeel();
        this.chooser.setDialogTitle(title);
        this.chooser.updateUI();
        this.chooser.setFileFilter(filter);
        int result = isOpen ? this.chooser.showOpenDialog(null) : this.chooser.showSaveDialog(null);
        this.setDefaultLookAndFeel();
        File file = null;
        if (result == 0) {
            file = this.chooser.getSelectedFile();
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStrings(File file, String[] args) {
        if (file == null || args == null) {
            return;
        }
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(file, false));
            for (int j = 0; j < args.length; ++j) {
                bw.write(args[j]);
                bw.newLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStrings(File file, Collection<String> args) {
        if (file == null || args == null) {
            return;
        }
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(file, false));
            for (String arg : args) {
                bw.write(arg);
                bw.newLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private File getSaveTextFile() {
        this.setFileFilter(txtFilter);
        File file = this.getSaveFile("Save file...");
        this.resetChoosableFileFilters();
        if (file != null) {
            String modifiedPath = Extension.replace(file.getPath(), "txt");
            return new File(modifiedPath);
        }
        return null;
    }

    public void writeStrings(String[] args) {
        SOSFileIO.writeStrings(this.getSaveTextFile(), args);
    }

    public void writeStrings(Collection<String> args) {
        SOSFileIO.writeStrings(this.getSaveTextFile(), args);
    }

    public ArrayList<String> readStrings() {
        this.setFileFilter(txtFilter);
        File file = this.getOpenFile("Open file...");
        this.resetChoosableFileFilters();
        return SOSFileIO.readStrings(file);
    }

    public static ArrayList<String> readStrings(File file) {
        if (file == null || !file.canRead()) {
            return null;
        }
        ArrayList<String> stringList = new ArrayList<String>();
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(file));
            while ((line = br.readLine()) != null) {
                stringList.add(line);
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return stringList;
    }
}

