package org.dyndns.nuda.tools.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Stack;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/**
 * XMLを解析し、結果をVで返します
 * 
 * @author nkoseki
 * 
 * @param <V>
 *            XML解析結果格納型
 */
public class DefaultXMLReader<V> extends DefaultHandler {
	private Stack<ScopeHandler<V>>	scopeStack	= new Stack<ScopeHandler<V>>();
	private ScopeHandler<V>			scope;
	private Context<V>				context;
	
	public DefaultXMLReader(final ScopeHandler<V> scope,
			final Context<V> context) {
		this.scope = scope;
		this.context = context;
	}
	
	@Override
	public void characters(final char[] ch, final int start, final int length)
			throws SAXException {
		
		this.scope.characters(this.context, ch, start, length);
	}
	
	@Override
	public void endElement(final String uri, final String localName,
			final String qName) throws SAXException {
		this.scope = this.scope.changeScope(this.scopeStack, qName);
		this.scope.endElement(this.context, uri, localName, qName);
	}
	
	@Override
	public void startElement(final String uri, final String localName,
			final String qName, final Attributes attributes)
			throws SAXException {
		
		this.scope = this.scope.changeScope(this.scopeStack, qName);
		this.scope
				.startElement(this.context, uri, localName, qName, attributes);
	}
	
	public V getResult() {
		return this.context.getValue();
	}
	
	public void read(final InputStream is) {
		try {
			SAXParserFactory factory = SAXParserFactory.newInstance();
			SAXParser perser = factory.newSAXParser();
			
			perser.parse(is, this);
		} catch (ParserConfigurationException e) {
			e.printStackTrace();
		} catch (SAXException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
	
	public void read(final File file) {
		try {
			SAXParserFactory factory = SAXParserFactory.newInstance();
			SAXParser perser = factory.newSAXParser();
			
			perser.parse(file, this);
		} catch (ParserConfigurationException e) {
			e.printStackTrace();
		} catch (SAXException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
	
	public void read(final String base) {
		InputStream is = null;
		try {
			try {
				SAXParserFactory factory = SAXParserFactory.newInstance();
				SAXParser perser = factory.newSAXParser();
				is = Thread.currentThread().getContextClassLoader()
						.getResourceAsStream(base);
				perser.parse(is, this);
			} finally {
				if (is != null) {
					is.close();
				}
			}
		} catch (ParserConfigurationException e) {
			e.printStackTrace();
		} catch (SAXException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		
	}
}
